/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.parser;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.internal.session.parser.SiriusSaxParserNormalAbortException;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepresentationsFileHandler
extends DefaultHandler {
    private boolean dAnalysisModels;
    private boolean dAnalysisReferencedAnalysis;
    private final URI sessionURI;
    private Set<URI> usedModels = Sets.newLinkedHashSet();
    private Set<URI> referencedAnalysis = Sets.newLinkedHashSet();

    public RepresentationsFileHandler(URI sessionURI) {
        this.sessionURI = sessionURI;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(ViewpointPackage.eINSTANCE.getDAnalysis_Models().getName())) {
            this.dAnalysisModels = true;
            String hrefValue = attributes.getValue("href");
            if (hrefValue != null) {
                this.usedModels.add(URI.createURI((String)hrefValue).resolve(this.sessionURI).trimFragment());
            }
        } else if (qName.equals(ViewpointPackage.eINSTANCE.getDAnalysis_ReferencedAnalysis().getName())) {
            this.dAnalysisReferencedAnalysis = true;
            String hrefValue = attributes.getValue("href");
            if (hrefValue != null) {
                this.referencedAnalysis.add(URI.createURI((String)hrefValue).resolve(this.sessionURI).trimFragment());
            }
        } else if (qName.equals(ViewpointPackage.eINSTANCE.getDAnalysis_OwnedViews().getName()) && (this.dAnalysisReferencedAnalysis || this.dAnalysisModels)) {
            throw new SiriusSaxParserNormalAbortException("All needed informations have been reached. Stop the parsing.");
        }
    }

    public Set<URI> getUsedModels() {
        return this.usedModels;
    }

    public Set<URI> getReferencedAnalysis() {
        return this.referencedAnalysis;
    }
}

