/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.validation.description.constraints;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.tools.internal.validation.description.constraints.AbstractEStructuralFeatureCustomizationFeatureNameCommonToAppliedOnConstraint;
import org.eclipse.sirius.viewpoint.description.EAttributeCustomization;

public class EAttributeCustomizationAttributeNameCommonToAppliedOnConstraint
extends AbstractEStructuralFeatureCustomizationFeatureNameCommonToAppliedOnConstraint {
    private static final String EATTRIBUTE_NAME_ON = " EAttribute name on ";

    public IStatus validate(IValidationContext ctx) {
        IStatus status = null;
        EObject target = ctx.getTarget();
        if (target instanceof EAttributeCustomization) {
            EAttributeCustomization eAttributeCustomization = (EAttributeCustomization)target;
            status = this.validateEAttributeCustomization(eAttributeCustomization, ctx);
        }
        if (status == null) {
            status = ctx.createSuccessStatus();
        }
        return status;
    }

    private IStatus validateEAttributeCustomization(EAttributeCustomization eAttributeCustomization, IValidationContext ctx) {
        IStatus status = null;
        String attributeName = eAttributeCustomization.getAttributeName();
        Iterator appliedOnIterator = eAttributeCustomization.getAppliedOn().iterator();
        if (appliedOnIterator.hasNext()) {
            EObject firstStyleDescriptionElt = (EObject)appliedOnIterator.next();
            if (!this.isStyleDescriptionElt(firstStyleDescriptionElt)) {
                status = ctx.createFailureStatus(new Object[]{String.valueOf(this.getPath(firstStyleDescriptionElt)) + " doesn't concerns a style description or a style description element"});
            } else {
                EStructuralFeature eStructuralFeature = firstStyleDescriptionElt.eClass().getEStructuralFeature(attributeName);
                if (eStructuralFeature instanceof EAttribute) {
                    EClassifier firstEType = eStructuralFeature.getEType();
                    status = this.validateFollowingStyleDescriptionElts(appliedOnIterator, firstStyleDescriptionElt, firstEType, attributeName, ctx);
                } else {
                    status = eStructuralFeature == null ? ctx.createFailureStatus(new Object[]{String.valueOf(attributeName) + EATTRIBUTE_NAME_ON + this.getPath(firstStyleDescriptionElt) + " doesn't exists"}) : ctx.createFailureStatus(new Object[]{String.valueOf(attributeName) + EATTRIBUTE_NAME_ON + this.getPath(firstStyleDescriptionElt) + " concerns " + eStructuralFeature + " which is not a EAttribute"});
                }
            }
        }
        return status;
    }

    private IStatus validateFollowingStyleDescriptionElts(Iterator<EObject> appliedOnIterator, EObject firstStyleDescriptionElt, EClassifier firstEType, String attributeName, IValidationContext ctx) {
        IStatus status = null;
        while (appliedOnIterator.hasNext()) {
            EObject next = appliedOnIterator.next();
            if (!this.isStyleDescriptionElt(next)) {
                status = ctx.createFailureStatus(new Object[]{String.valueOf(this.getPath(next)) + " doesn't concerns a style description or a style description element"});
                break;
            }
            EStructuralFeature eStructuralFeature = next.eClass().getEStructuralFeature(attributeName);
            if (eStructuralFeature instanceof EAttribute) {
                if (firstEType == eStructuralFeature.getEType()) continue;
                status = ctx.createFailureStatus(new Object[]{String.valueOf(this.getPath(firstStyleDescriptionElt)) + " and " + this.getPath(next) + "have each a EAttribute named " + attributeName + " but with differents types"});
                break;
            }
            if (eStructuralFeature == null) {
                status = ctx.createFailureStatus(new Object[]{String.valueOf(attributeName) + EATTRIBUTE_NAME_ON + this.getPath(next) + " doesn't exists"});
                continue;
            }
            status = ctx.createFailureStatus(new Object[]{String.valueOf(attributeName) + EATTRIBUTE_NAME_ON + this.getPath(next) + " concerns " + eStructuralFeature + " which is not a EAttribute"});
            break;
        }
        return status;
    }
}

