/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FontFormat implements Enumerator
{
    NORMAL_LITERAL(0, "normal", "normal"),
    ITALIC_LITERAL(1, "italic", "italic"),
    BOLD_LITERAL(2, "bold", "bold"),
    BOLD_ITALIC_LITERAL(3, "bold_italic", "bold_italic");

    public static final int NORMAL = 0;
    public static final int ITALIC = 1;
    public static final int BOLD = 2;
    public static final int BOLD_ITALIC = 3;
    private static final FontFormat[] VALUES_ARRAY;
    public static final List<FontFormat> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FontFormat[]{NORMAL_LITERAL, ITALIC_LITERAL, BOLD_LITERAL, BOLD_ITALIC_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FontFormat get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FontFormat result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FontFormat getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FontFormat result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FontFormat get(int value) {
        switch (value) {
            case 0: {
                return NORMAL_LITERAL;
            }
            case 1: {
                return ITALIC_LITERAL;
            }
            case 2: {
                return BOLD_LITERAL;
            }
            case 3: {
                return BOLD_ITALIC_LITERAL;
            }
        }
        return null;
    }

    private FontFormat(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

