/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import java.util.Collections;
import java.util.Vector;
import org.agilemore.agilegrid.ColumnSortComparator;
import org.agilemore.agilegrid.ICompositorStrategy;
import org.agilemore.agilegrid.ILayoutAdvisor;

public class DefaultCompositorStrategy
implements ICompositorStrategy {
    private ILayoutAdvisor layoutAdvisor;
    private int ordered = -1;
    private int sortColumn = -1;
    private ColumnSortComparator currentSortComparator = null;
    private Vector<Integer> rowMapping;

    public DefaultCompositorStrategy(ILayoutAdvisor layoutAdvisor) {
        this.layoutAdvisor = layoutAdvisor;
        int numberOfElems = layoutAdvisor.getRowCount() - layoutAdvisor.getFixedRowCount();
        this.rowMapping = new Vector(numberOfElems);
        int fixedRowCount = layoutAdvisor.getFixedRowCount();
        int i = 0;
        while (i < numberOfElems) {
            this.rowMapping.add(i, new Integer(i + fixedRowCount));
            ++i;
        }
    }

    public void resetRowMapping() {
        int numberOfElems = this.layoutAdvisor.getRowCount();
        this.rowMapping = new Vector(numberOfElems);
    }

    @Override
    public int getSortState() {
        return this.ordered;
    }

    @Override
    public void sort(ColumnSortComparator comparator) {
        Collections.sort(this.rowMapping, comparator);
        this.ordered = comparator.getSortDirection();
        if (this.ordered == -1) {
            this.setSortColumn(-1);
        } else {
            this.setSortColumn(comparator.getColumnToSortOn());
        }
        this.currentSortComparator = comparator;
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void setSortColumn(int column) {
        this.sortColumn = column;
    }

    @Override
    public int mapRowIndexToContent(int shownRow) {
        int bodyRow;
        if (shownRow < this.layoutAdvisor.getFixedRowCount()) {
            return shownRow;
        }
        if (shownRow - this.getFixedRowCount() >= this.rowMapping.size()) {
            int fixedRowCount = this.layoutAdvisor.getFixedRowCount();
            int i = this.rowMapping.size();
            while (i < this.layoutAdvisor.getRowCount() - fixedRowCount) {
                this.rowMapping.add(i, new Integer(i + fixedRowCount));
                ++i;
            }
        }
        if ((bodyRow = shownRow - this.getFixedRowCount()) < 0 || bodyRow >= this.rowMapping.size()) {
            return shownRow;
        }
        int mappedRow = this.rowMapping.get(bodyRow);
        if (mappedRow >= this.layoutAdvisor.getRowCount() || mappedRow < 0) {
            this.resetRowMapping();
            if (this.currentSortComparator != null) {
                this.sort(this.currentSortComparator);
            }
            return this.mapRowIndexToContent(shownRow);
        }
        return mappedRow;
    }

    @Override
    public int mapRowIndexToAgileGrid(int modelRow) {
        if (modelRow < this.layoutAdvisor.getFixedRowCount()) {
            return modelRow;
        }
        int i = 0;
        while (i < this.rowMapping.size()) {
            Integer im = this.rowMapping.get(i);
            if (im == modelRow) {
                return i + this.getFixedRowCount();
            }
            ++i;
        }
        return modelRow;
    }

    private int getFixedRowCount() {
        return this.layoutAdvisor.getFixedRowCount();
    }
}

