/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import java.util.Hashtable;
import org.agilemore.agilegrid.AbstractLayoutAdvisor;
import org.agilemore.agilegrid.AgileGrid;

public class DefaultLayoutAdvisor
extends AbstractLayoutAdvisor {
    private Hashtable<Integer, Integer> rowHeights = new Hashtable();
    protected Hashtable<Integer, Integer> colWidths = new Hashtable();
    protected int leftHeaderWidth = 35;
    protected int topHeaderHeight = 18;

    public DefaultLayoutAdvisor(AgileGrid agileGrid) {
        super(agileGrid);
    }

    @Override
    public int getColumnWidth(int col) {
        Integer width = this.colWidths.get(new Integer(col));
        if (width == null) {
            int initWidth = this.getInitialColumnWidth(col);
            if (initWidth < 0) {
                return 0;
            }
            return initWidth;
        }
        return width;
    }

    @Override
    protected void doSetColumnWidth(int col, int width) {
        if (width < 0) {
            width = 0;
        }
        this.colWidths.put(new Integer(col), new Integer(width));
    }

    @Override
    protected void doSetRowHeight(int row, int height) {
        if (height < 0) {
            height = 0;
        }
        this.rowHeights.put(new Integer(row), new Integer(height));
    }

    @Override
    public int getRowHeight(int row) {
        Integer height = this.rowHeights.get(new Integer(row));
        if (height == null) {
            int h;
            if (row == 0 && (h = this.getInitialRowHeight(0)) > 2) {
                return h;
            }
            int initialH = this.getInitialRowHeight(row);
            if (initialH < 2) {
                return 2;
            }
            return initialH;
        }
        if (height < 2) {
            return 2;
        }
        return height;
    }

    @Override
    public int getInitialColumnWidth(int column) {
        return 80;
    }

    @Override
    public int getInitialRowHeight(int row) {
        return 18;
    }

    @Override
    public int getFixedColumnCount() {
        return 0;
    }

    @Override
    public int getFixedRowCount() {
        return 0;
    }

    @Override
    public int getRowHeightMinimum() {
        return 0;
    }

    @Override
    public boolean isColumnResizable(int col) {
        return true;
    }

    @Override
    public boolean isRowResizable(int row) {
        return true;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return 6;
    }

    @Override
    public int getLeftHeaderWidth() {
        return this.leftHeaderWidth;
    }

    @Override
    public int getTopHeaderHeight() {
        return this.topHeaderHeight;
    }

    @Override
    public boolean isLeftHeaderVisible() {
        return true;
    }

    @Override
    public boolean isTopHeaderVisible() {
        return true;
    }

    @Override
    public String getLeftHeaderLabel(int row) {
        return Integer.toString(row);
    }

    @Override
    public String getTopHeaderLabel(int col) {
        String result = "";
        while (col >= 0) {
            result = String.valueOf((char)((char)(col % 26) + 65)) + result;
            col = col / 26 - 1;
        }
        return result;
    }

    @Override
    protected void doSetColumnCount(int columnCount) {
    }

    @Override
    protected void doSetFixedColumnCount(int fixedColumnCount) {
    }

    @Override
    protected void doSetFixedRowCount(int fixedRowCount) {
    }

    @Override
    protected void doSetLeftHeaderLabel(int row, String label) {
    }

    @Override
    protected void doSetLeftHeaderVisible(boolean visible) {
    }

    @Override
    protected void doSetLeftHeaderWidth(int width) {
        this.leftHeaderWidth = width;
    }

    @Override
    protected void doSetRowCount(int rowCount) {
    }

    @Override
    protected void doSetRowHeightMinimum(int minimumHeight) {
    }

    @Override
    protected void doSetRowResizable(int row, boolean resizable) {
    }

    @Override
    protected void doSetTooltipAt(int row, int col, String tooltip) {
    }

    @Override
    protected void doSetTopHeaderHeight(int height) {
        this.topHeaderHeight = height;
    }

    @Override
    protected void doSetTopHeaderLabel(int col, String label) {
    }

    @Override
    protected void doSetTopHeaderVisible(boolean visible) {
    }

    @Override
    public String getTooltip(int row, int col) {
        return null;
    }

    @Override
    public void setColumnResizable(int col, boolean resizable) {
    }
}

