/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.DefaultLayoutAdvisor;
import org.agilemore.agilegrid.ILayoutAdvisor;
import org.eclipse.swt.graphics.Rectangle;

public class ScalableColumnLayoutAdvisor
extends DefaultLayoutAdvisor {
    private int FACTOR = 10000;

    public ScalableColumnLayoutAdvisor(AgileGrid agileGrid) {
        super(agileGrid);
        this.initialize();
    }

    public void initialize() {
        int weightSum = 1;
        int i = 0;
        while (i < this.getColumnCount()) {
            int initialWeight = this.getInitialColumnWidth(i);
            weightSum += initialWeight;
            ++i;
        }
        i = 0;
        while (i < this.getColumnCount()) {
            super.setColumnWidth(i, (int)((double)this.getInitialColumnWidth(i) / (double)weightSum * (double)this.FACTOR) - 1);
            ++i;
        }
        int pts = 0;
        int i2 = 0;
        while (i2 < this.getColumnCount()) {
            pts += super.getColumnWidth(i2);
            ++i2;
        }
        this.FACTOR = pts;
    }

    @Override
    public int getColumnWidth(int col) {
        ILayoutAdvisor layoutAdvisor = this.agileGrid.getLayoutAdvisor();
        Rectangle clientArea = this.agileGrid.getClientArea();
        int width = clientArea.width - this.agileGrid.getLinePixels() * (this.getColumnCount() + 1);
        if (layoutAdvisor.isLeftHeaderVisible()) {
            width -= layoutAdvisor.getLeftHeaderWidth();
            width -= this.agileGrid.getLinePixels();
        }
        double percent = (double)super.getColumnWidth(col) / (double)this.FACTOR;
        if (this.agileGrid != null && !this.agileGrid.isDisposed()) {
            return (int)((double)width * percent);
        }
        return (int)Math.round(percent * 100.0);
    }

    @Override
    public void setColumnWidth(int col, int value) {
        int width = this.agileGrid.getClientArea().width;
        double percent = (double)(value + 1) / (double)width;
        if (col == this.getColumnCount() - 1) {
            int weightsum = super.getColumnWidth(col) + super.getColumnWidth(col - 1);
            super.setColumnWidth(col, (int)(percent * (double)this.FACTOR));
            super.setColumnWidth(col - 1, weightsum - (int)(percent * (double)this.FACTOR));
        } else {
            int weightsum = super.getColumnWidth(col) + super.getColumnWidth(col + 1);
            super.setColumnWidth(col, (int)(percent * (double)this.FACTOR));
            super.setColumnWidth(col + 1, weightsum - (int)(percent * (double)this.FACTOR));
        }
    }
}

