/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid.editors;

import java.text.MessageFormat;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.CellEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class DialogCellEditor
extends CellEditor {
    public static final String CELL_EDITOR_IMG_DOTS_BUTTON = "cell_editor_dots_button_image";
    private Composite editor;
    private Control contents;
    private Label defaultLabel;
    private Button button;
    private FocusListener buttonFocusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            DialogCellEditor.this.focusLost();
        }
    };
    private Object value = null;
    private static final int defaultStyle = 0;

    public DialogCellEditor(AgileGrid agileGrid) {
        this(agileGrid, 0);
    }

    public DialogCellEditor(AgileGrid agileGrid, int style) {
        super(agileGrid, style);
    }

    protected Button createButton(Composite parent) {
        Button button = new Button(parent, 1028);
        return button;
    }

    protected Control createContents(Composite parent) {
        this.defaultLabel = new Label(parent, 0x804000);
        this.defaultLabel.setFont(parent.getFont());
        this.defaultLabel.setBackground(parent.getBackground());
        return this.defaultLabel;
    }

    @Override
    protected Control createControl(AgileGrid agileGrid) {
        Font font = agileGrid.getFont();
        Color bg = agileGrid.getBackground();
        this.editor = new Composite((Composite)agileGrid, this.getStyle());
        this.editor.setFont(font);
        this.editor.setBackground(bg);
        this.editor.setLayout((Layout)new DialogCellLayout());
        this.contents = this.createContents(this.editor);
        this.updateContents(this.value);
        this.button = this.createButton(this.editor);
        this.button.setFont(font);
        this.button.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    DialogCellEditor.this.fireCancelEditor();
                }
            }
        });
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogCellEditor.this.button.removeFocusListener(DialogCellEditor.this.buttonFocusListener);
                Object newValue = DialogCellEditor.this.openDialogBox((Control)DialogCellEditor.this.editor);
                DialogCellEditor.this.button.addFocusListener(DialogCellEditor.this.buttonFocusListener);
                if (newValue != null) {
                    boolean newValidState = DialogCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        DialogCellEditor.this.markDirty();
                        DialogCellEditor.this.doSetValue(newValue);
                    } else {
                        DialogCellEditor.this.setErrorMessage(MessageFormat.format(DialogCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                    DialogCellEditor.this.fireApplyEditorValue();
                } else {
                    DialogCellEditor.this.fireCancelEditor();
                }
            }
        });
        this.setValueValid(true);
        return this.editor;
    }

    @Override
    public void deactivate() {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.removeFocusListener(this.buttonFocusListener);
        }
        super.deactivate();
    }

    @Override
    protected Object doGetValue() {
        return this.value;
    }

    @Override
    protected void doSetFocus() {
        this.button.addFocusListener(this.buttonFocusListener);
        this.button.setFocus();
    }

    @Override
    protected void doSetValue(Object value) {
        this.value = value;
        this.updateContents(value);
    }

    protected Label getDefaultLabel() {
        return this.defaultLabel;
    }

    protected abstract Object openDialogBox(Control var1);

    protected void updateContents(Object value) {
        if (this.defaultLabel == null) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        this.defaultLabel.setText(text);
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = DialogCellEditor.this.button.computeSize(-1, -1, force);
            if (DialogCellEditor.this.contents != null) {
                DialogCellEditor.this.contents.setBounds(0, 0, bounds.width - size.x, bounds.height);
            }
            DialogCellEditor.this.button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = DialogCellEditor.this.contents.computeSize(-1, -1, force);
            Point buttonSize = DialogCellEditor.this.button.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

