/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import com.google.common.collect.HashMultimap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.LostMessageEnd;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.ResizeViewOperation;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.InstanceRoleEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.InstanceRoleMoveValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.InstanceRoleResizeValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.business.internal.operation.MoveViewOperation;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.AirResizableEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.api.command.DoNothingCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.ext.base.Option;

public class InstanceRoleResizableEditPolicy
extends AirResizableEditPolicy {
    private static final String INSTANCE_ROLE_MOVE_COMMAND_NAME = "InstanceRole move";
    private static final String INSTANCE_ROLE_RESIZE_COMMAND_NAME = "InstanceRole resize";

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        this.cancelVerticalMoveDelta(request);
        DoNothingCommand result = DoNothingCommand.INSTANCE;
        RequestQuery requestQuery = new RequestQuery((Request)request);
        if (this.getHost().getSelected() == 2 && requestQuery.isMove()) {
            InstanceRoleMoveValidator validator = new InstanceRoleMoveValidator();
            List<InstanceRole> instanceRoles = requestQuery.getInstanceRoles();
            validator.setSequenceElements(instanceRoles);
            result = UnexecutableCommand.INSTANCE;
            if (validator.isValid(request)) {
                result = this.getMoveCommand(validator, requestQuery);
            }
        }
        return result;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        this.cancelVerticalMoveDelta(request);
        super.showChangeBoundsFeedback(request);
    }

    private Command getMoveCommand(InstanceRoleMoveValidator validator, RequestQuery requestQuery) {
        GraphicalEditPart host = (GraphicalEditPart)this.getHost();
        TransactionalEditingDomain transactionalEditingDomain = host.getEditingDomain();
        CompositeTransactionalCommand compositeCommand = new CompositeTransactionalCommand(transactionalEditingDomain, INSTANCE_ROLE_MOVE_COMMAND_NAME);
        ICommand moveCmds = this.getMoveViewCommands(transactionalEditingDomain, validator.getMoveDeltas());
        if (moveCmds != null && moveCmds.canExecute()) {
            compositeCommand.compose((IUndoableOperation)moveCmds);
        }
        this.postProcessDefaultCommand((InstanceRoleEditPart)this.getHost(), compositeCommand, requestQuery);
        CompositeTransactionalCommand solution = compositeCommand;
        if (!solution.canExecute()) {
            solution = IdentityCommand.INSTANCE;
        }
        return new ICommandProxy((ICommand)solution);
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        DoNothingCommand result = DoNothingCommand.INSTANCE;
        RequestQuery requestQuery = new RequestQuery((Request)request);
        if (this.getHost().getSelected() == 2 && requestQuery.isResize()) {
            InstanceRoleResizeValidator validator = new InstanceRoleResizeValidator();
            List<InstanceRole> instanceRoles = requestQuery.getInstanceRoles();
            validator.setSequenceElements(instanceRoles);
            result = UnexecutableCommand.INSTANCE;
            if (validator.isValid(request)) {
                result = this.getResizeCommand(validator, new RequestQuery((Request)request));
            }
        }
        return result;
    }

    private Command getResizeCommand(InstanceRoleResizeValidator validator, RequestQuery requestQuery) {
        ICommand resizeViewCmd;
        GraphicalEditPart host = (GraphicalEditPart)this.getHost();
        TransactionalEditingDomain transactionalEditingDomain = host.getEditingDomain();
        CompositeTransactionalCommand compositeCommand = new CompositeTransactionalCommand(transactionalEditingDomain, INSTANCE_ROLE_RESIZE_COMMAND_NAME);
        ICommand moveViewCmd = this.getMoveViewCommands(transactionalEditingDomain, validator.getMoveDeltas());
        if (moveViewCmd != null && moveViewCmd.canExecute()) {
            compositeCommand.compose((IUndoableOperation)moveViewCmd);
        }
        if ((resizeViewCmd = this.getResizeViewCommands(transactionalEditingDomain, validator.getSizeDeltas())) != null && resizeViewCmd.canExecute()) {
            compositeCommand.compose((IUndoableOperation)resizeViewCmd);
        }
        this.postProcessDefaultCommand((InstanceRoleEditPart)this.getHost(), compositeCommand, requestQuery);
        CompositeTransactionalCommand solution = compositeCommand;
        if (!solution.canExecute()) {
            solution = IdentityCommand.INSTANCE;
        }
        return new ICommandProxy((ICommand)solution);
    }

    private ICommand getMoveViewCommands(TransactionalEditingDomain transactionalEditingDomain, Map<InstanceRole, Point> moveDeltas) {
        CompositeTransactionalCommand compositeCommand = new CompositeTransactionalCommand(transactionalEditingDomain, "");
        HashMultimap lostNodes = HashMultimap.create();
        InstanceRoleEditPart irep = (InstanceRoleEditPart)this.getHost();
        SequenceDiagram diagram = irep.getInstanceRole().getDiagram();
        for (Message message : diagram.getAllMessages()) {
            ISequenceNode sourceElement = message.getSourceElement();
            Option sourceLifeline = sourceElement.getLifeline();
            ISequenceNode targetElement = message.getTargetElement();
            Option targetLifeline = targetElement.getLifeline();
            if (sourceLifeline.some() && targetElement instanceof LostMessageEnd) {
                lostNodes.put((Object)((Lifeline)sourceLifeline.get()).getInstanceRole(), (Object)((LostMessageEnd)targetElement));
                continue;
            }
            if (!(sourceElement instanceof LostMessageEnd) || !targetLifeline.some()) continue;
            lostNodes.put((Object)((Lifeline)targetLifeline.get()).getInstanceRole(), (Object)((LostMessageEnd)sourceElement));
        }
        for (Map.Entry entry : moveDeltas.entrySet()) {
            Point delta = (Point)entry.getValue();
            if (delta.x == 0 && delta.y == 0) continue;
            InstanceRole instanceRole = (InstanceRole)entry.getKey();
            this.addMoveViewCommand(transactionalEditingDomain, compositeCommand, delta, (ISequenceNode)instanceRole);
            for (LostMessageEnd lme : lostNodes.get((Object)instanceRole)) {
                this.addMoveViewCommand(transactionalEditingDomain, compositeCommand, delta, (ISequenceNode)lme);
            }
        }
        return compositeCommand;
    }

    private void addMoveViewCommand(TransactionalEditingDomain transactionalEditingDomain, CompositeTransactionalCommand compositeCommand, Point delta, ISequenceNode sequenceNode) {
        EObjectAdapter adapter = new EObjectAdapter((EObject)sequenceNode.getNotationNode());
        MoveViewOperation moveViewOperation = new MoveViewOperation(DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)adapter, delta);
        ICommand moveCmd = CommandFactory.createICommand((TransactionalEditingDomain)transactionalEditingDomain, (AbstractModelChangeOperation)moveViewOperation);
        compositeCommand.add((IUndoableOperation)moveCmd);
    }

    private ICommand getResizeViewCommands(TransactionalEditingDomain transactionalEditingDomain, Map<InstanceRole, Dimension> sizeDeltas) {
        CompositeTransactionalCommand compositeCommand = new CompositeTransactionalCommand(transactionalEditingDomain, "");
        for (Map.Entry<InstanceRole, Dimension> entry : sizeDeltas.entrySet()) {
            Dimension sizeDelta = entry.getValue();
            if (sizeDelta.width == 0 && sizeDelta.height == 0) continue;
            InstanceRole instanceRole = entry.getKey();
            EObjectAdapter adapter = new EObjectAdapter((EObject)instanceRole.getNotationView());
            ResizeViewOperation resizeViewOperation = new ResizeViewOperation(DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)adapter, sizeDelta);
            ICommand resizeCmd = CommandFactory.createICommand((TransactionalEditingDomain)transactionalEditingDomain, (AbstractModelChangeOperation)resizeViewOperation);
            compositeCommand.add((IUndoableOperation)resizeCmd);
        }
        if (!compositeCommand.canExecute()) {
            return null;
        }
        return compositeCommand;
    }

    protected Command getAutoSizeCommand(Request request) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getAlignCommand(AlignmentRequest request) {
        return UnexecutableCommand.INSTANCE;
    }

    protected void cancelVerticalMoveDelta(ChangeBoundsRequest request) {
        Point moveDelta;
        if (request == null) {
            return;
        }
        RequestQuery query = new RequestQuery((Request)request);
        if (query.isMove() && (moveDelta = request.getMoveDelta().getCopy()) != null) {
            request.setMoveDelta(new Point(moveDelta.x, 0));
        }
    }

    private void postProcessDefaultCommand(InstanceRoleEditPart self, CompositeTransactionalCommand command, RequestQuery requestQuery) {
        if (command != null && command.canExecute()) {
            SequenceEditPartsOperations.addRefreshGraphicalOrderingCommand(command, (IGraphicalEditPart)self);
            SequenceEditPartsOperations.addRefreshSemanticOrderingCommand(command, (IGraphicalEditPart)self);
            if (requestQuery.isMultiSelectionOperation()) {
                SequenceEditPartsOperations.addSynchronizeSemanticOrderingCommand(command, self.getInstanceRole(), requestQuery.getInstanceRoles());
            } else {
                SequenceEditPartsOperations.addSynchronizeSemanticOrderingCommand(command, self.getInstanceRole());
            }
        }
    }
}

