/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.business.internal.interpreter;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.query.legacy.AcceleoInterpreterPlugin;
import org.eclipse.sirius.query.legacy.business.internal.interpreter.AcceleoCompletionEntry;
import org.eclipse.sirius.query.legacy.business.internal.interpreter.AcceleoInterpreter;
import org.eclipse.sirius.query.legacy.business.internal.interpreter.SmartSpecificScript;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxExceptions;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.log.EvalFailure;
import org.eclipse.sirius.query.legacy.gen.template.scripts.SpecificScript;
import org.eclipse.sirius.query.legacy.tools.classloaders.AcceleoClassLoader;
import org.eclipse.sirius.query.legacy.tools.plugins.AcceleoModuleProvider;
import org.eclipse.sirius.query.legacy.tools.resources.Resources;

public class AcceleoExtendedInterpreter
extends AcceleoInterpreter {
    private static final boolean LOG_WARNINGS = false;
    private static final String ACCELEO_PLUGIN_NAME = AcceleoInterpreterPlugin.getDefault().getBundle().getSymbolicName();
    protected ModelAccessor accessor;
    private ECrossReferenceAdapter crossReferencer;
    private final List<File> representationDescriptionFiles = new ArrayList<File>();

    public AcceleoExtendedInterpreter() {
    }

    public AcceleoExtendedInterpreter(ModelAccessor accessor) {
        this();
        this.accessor = accessor;
    }

    @Deprecated
    public AcceleoExtendedInterpreter(File representationDescriptionFile) {
        this();
        this.representationDescriptionFiles.add(representationDescriptionFile);
    }

    @Override
    protected SpecificScript createNewScript(EObject current, String mmURI) {
        File moreSpecificRepresentationDescriptionFile;
        File file = moreSpecificRepresentationDescriptionFile = this.representationDescriptionFiles != null && !this.representationDescriptionFiles.isEmpty() ? this.representationDescriptionFiles.get(0) : null;
        if (moreSpecificRepresentationDescriptionFile == null && current != null && current.eResource() != null) {
            try {
                if (current.eResource().getURI().path() != null && Resources.getIFile(current.eResource()) != null && Resources.getIFile(current.eResource()).getLocation() != null) {
                    moreSpecificRepresentationDescriptionFile = Resources.getIFile(current.eResource()).getLocation().toFile();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (current != null) {
            AcceleoClassLoader.setPreferredClassLoader(current.getClass().getClassLoader());
        }
        SmartSpecificScript newScript = new SmartSpecificScript(moreSpecificRepresentationDescriptionFile, this.representationDescriptionFiles, this);
        newScript.setCrossReferencer(this.crossReferencer);
        try {
            String templateHeader = this.getScriptHeader(mmURI);
            newScript.reset(templateHeader);
        }
        catch (TemplateSyntaxExceptions e) {
            AcceleoInterpreterPlugin.getDefault().error("Syntax error in template while initializing the interpreter.", e);
        }
        AcceleoClassLoader.setPreferredClassLoader(null);
        return newScript;
    }

    @Override
    public Object evaluate(EObject eObj, String expression) throws EvaluationException {
        PrintStream originalOut = System.out;
        ENode result = null;
        result = this.doEvaluate(eObj, expression);
        if (originalOut != System.out) {
            System.setOut(originalOut);
        }
        return this.getValue(result, expression);
    }

    private ENode doEvaluate(EObject eObj, String expression) throws EvaluationException {
        EvalFailure evalFailure;
        ENodeException.disableRuntimeMarkersFor(eObj);
        ENode result = super.evaluateENode(eObj, expression);
        ENodeException.enableRuntimeMarkersFor(eObj);
        if (result.log().allErrors().hasNext() && this.isMessageToThrow((evalFailure = (EvalFailure)result.log().allErrors().next()).getMessage())) {
            throw new EvaluationException(evalFailure.getMessage());
        }
        return result;
    }

    private boolean isMessageToThrow(String message) {
        String endOfMessage;
        String evalFormater = AcceleoGenMessages.getString("EvalFailure.FailureMessage");
        String evalPrefix = MessageFormat.format(evalFormater, "");
        return message == null || !message.startsWith(evalPrefix) || !(endOfMessage = message.substring(evalPrefix.length())).startsWith(AcceleoGenMessages.getString("ENodeError.EmptyEvaluation"));
    }

    @Override
    public void setModelAccessor(ModelAccessor modelAccessor) {
        this.accessor = modelAccessor;
    }

    @Override
    public IInterpreter createInterpreter() {
        return new AcceleoExtendedInterpreter();
    }

    @Override
    public void setProperty(Object key, Object value) {
        if ("files".equals(key)) {
            if (value instanceof List) {
                List odesignPaths = (List)value;
                for (String odesignPath : odesignPaths) {
                    File file = AcceleoModuleProvider.getDefault().getFile((IPath)new Path(odesignPath));
                    if (file == null) continue;
                    this.representationDescriptionFiles.add(file);
                }
            } else if (value == null) {
                this.representationDescriptionFiles.clear();
            }
        }
        super.setProperty(key, value);
    }

    @Override
    public void setCrossReferencer(ECrossReferenceAdapter crossReferencer) {
        this.crossReferencer = crossReferencer;
        if (crossReferencer != null) {
            for (SpecificScript script : this.mmToScript.values()) {
                if (!(script instanceof SmartSpecificScript)) continue;
                ((SmartSpecificScript)script).setCrossReferencer(crossReferencer);
            }
        }
    }

    @Override
    protected AcceleoCompletionEntry getCompletionEntry() {
        return new AcceleoCompletionEntry(){

            @Override
            protected void addModelElements(Object[] proposals, List<Object> contents) {
                if (this.element == null || AcceleoExtendedInterpreter.this.accessor == null || !AcceleoExtendedInterpreter.this.accessor.eInstanceOf(this.element, "tool.ModelOperation")) {
                    super.addModelElements(proposals, contents);
                }
            }
        };
    }

    public Collection<IInterpreterStatus> validateExpression(IInterpreterContext context, String expression) {
        return Sets.newLinkedHashSet();
    }

    public boolean supportsValidation() {
        return false;
    }
}

