/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.tools.resources.Resources;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;

public abstract class TemplateElement {
    protected IScript script;
    protected TemplateElement parent = null;
    protected List children = new ArrayList();
    protected TemplateElement next = null;
    protected TemplateElement previous = null;
    protected Int2 pos = Int2.NOT_FOUND;
    protected Integer line = null;

    public TemplateElement(IScript script) {
        this.script = script;
    }

    public IScript getScript() {
        return this.script;
    }

    public Int2 getPos() {
        return this.pos;
    }

    public void setPos(Int2 pos) {
        this.pos = pos;
        this.line = null;
    }

    public int getLine() {
        if (this.line == null) {
            this.line = this.pos.b() == -1 || this.getScript() == null || this.getScript().getFile() == null ? new Integer(0) : new Integer(TextSearch.getDefaultSearch().lineNumber(this.getScript().getFile(), this.pos.b()));
        }
        return this.line;
    }

    public void setParent(TemplateElement parent) {
        this.parent = parent;
        if (parent != null) {
            if (parent.children.size() > 0) {
                TemplateElement previous;
                this.previous = previous = (TemplateElement)parent.children.get(parent.children.size() - 1);
                previous.next = this;
            }
            parent.children.add(this);
        }
    }

    public TemplateElement getParent() {
        return this.parent;
    }

    public TemplateElement getPrevious() {
        return this.previous;
    }

    public TemplateElement getNext() {
        return this.next;
    }

    public TemplateElement[] getChildren() {
        return this.children.toArray(new TemplateElement[this.children.size()]);
    }

    public TemplateElement[] getChildren(Class c) {
        ArrayList<TemplateElement> result = new ArrayList<TemplateElement>();
        for (TemplateElement element : this.children) {
            if (!c.isInstance(element)) continue;
            result.add(element);
        }
        return result.toArray(new TemplateElement[result.size()]);
    }

    public TemplateElement[] getChildren(Class[] classes, Class[] gatewayClasses) {
        ArrayList<TemplateElement> result = new ArrayList<TemplateElement>();
        for (TemplateElement element : this.children) {
            Class c;
            boolean instance = false;
            int i = 0;
            while (i < gatewayClasses.length && !instance) {
                c = gatewayClasses[i];
                if (c.isInstance(element)) {
                    result.addAll(Arrays.asList(element.getChildren(classes, gatewayClasses)));
                    instance = true;
                }
                ++i;
            }
            i = 0;
            while (i < classes.length && !instance) {
                c = classes[i];
                if (c.isInstance(element)) {
                    result.add(element);
                    instance = true;
                }
                ++i;
            }
        }
        return result.toArray(new TemplateElement[result.size()]);
    }

    public List getAllElements(Class c) {
        ArrayList<TemplateElement> result = new ArrayList<TemplateElement>();
        if (c.isInstance(this)) {
            result.add(this);
        }
        for (TemplateElement element : this.children) {
            result.addAll(element.getAllElements(c));
        }
        return result;
    }

    public String getURIFragment() {
        StringBuffer fragment = new StringBuffer("");
        if (this.script != null && this.script.getFile() != null) {
            fragment.append(Resources.encodeAcceleoAbsolutePath(this.script.getFile().getAbsolutePath()));
        }
        fragment.append(" //pos=");
        fragment.append(this.pos.b());
        fragment.append(',');
        fragment.append(this.pos.e());
        return fragment.toString();
    }

    public static File getTemplateFileFromURIFragment(String uriFragment) {
        int i;
        String path;
        File file;
        if (uriFragment != null && (file = new File(Resources.decodeAcceleoAbsolutePath(path = (i = uriFragment.indexOf(" //pos=")) > -1 ? uriFragment.substring(0, i).trim() : uriFragment))).exists()) {
            return file;
        }
        return null;
    }

    public static Int2 getPositionFromURIFragment(String uriFragment) {
        String pos;
        int i;
        if (uriFragment != null && (i = uriFragment.indexOf(" //pos=")) > -1 && (i = (pos = uriFragment.substring(i + " //pos=".length()).trim()).indexOf(",")) > -1) {
            String b = pos.substring(0, i).trim();
            String e = pos.substring(i + 1).trim();
            return new Int2(Integer.parseInt(b), Integer.parseInt(e));
        }
        return Int2.NOT_FOUND;
    }
}

