/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.expressions;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.ecore.tools.ETools;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.gen.template.scripts.SpecificScript;
import org.eclipse.sirius.query.legacy.tools.format.Conventions;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;

public class TemplateLiteralExpression
extends TemplateExpression {
    protected static final String LITERAL_TRUE = "true";
    protected static final String LITERAL_FALSE = "false";
    protected static final String LITERAL_NULL = "null";
    protected Object value;

    public TemplateLiteralExpression(String value, IScript script) {
        super(script);
        this.value = value;
    }

    public TemplateLiteralExpression(boolean value, IScript script) {
        super(script);
        this.value = new Boolean(value);
    }

    public TemplateLiteralExpression(int value, IScript script) {
        super(script);
        this.value = new Integer(value);
    }

    public TemplateLiteralExpression(double value, IScript script) {
        super(script);
        this.value = new Double(value);
    }

    public TemplateLiteralExpression(IScript script) {
        super(script);
        this.value = null;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public ENode evaluate(ENode current, IScript script, LaunchManager mode) throws ENodeException, FactoryException {
        ENode result = this.value == null ? new ENode(ENode.EMPTY, current) : (this.value instanceof String ? new ENode((String)this.value, current) : (this.value instanceof Boolean ? new ENode((Boolean)this.value, current) : (this.value instanceof Integer ? new ENode((Integer)this.value, current) : (this.value instanceof Double ? new ENode((Double)this.value, current) : new ENode(ENode.EMPTY, current)))));
        return result;
    }

    public String toString() {
        if (this.value == null) {
            return LITERAL_NULL;
        }
        if (this.value instanceof String) {
            return String.valueOf(TemplateConstants.LITERAL[0]) + Conventions.formatString((String)this.value) + TemplateConstants.LITERAL[1];
        }
        return this.value.toString();
    }

    public EClassifier resolveAsEClassifier() {
        if (this.value != null && this.value instanceof String && this.script != null && this.script instanceof SpecificScript && ((SpecificScript)this.script).getMetamodel() != null) {
            String id = (String)this.value;
            EClassifier result = ETools.getEClassifier(((SpecificScript)this.script).getMetamodel(), id);
            if (result == null) {
                result = ETools.getEClassifier((EPackage)EcorePackage.eINSTANCE, id);
            }
            return result;
        }
        return null;
    }

    public static TemplateExpression fromString(String buffer, Int2 limits, IScript script) throws TemplateSyntaxException {
        TemplateLiteralExpression expression;
        Int2 trim = TextSearch.getDefaultSearch().trim(buffer, limits.b(), limits.e());
        if (trim.b() == -1) {
            throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingElement"), script, limits);
        }
        limits = trim;
        String text = buffer.substring(limits.b(), limits.e());
        if (text.length() >= TemplateConstants.LITERAL[0].length() + TemplateConstants.LITERAL[1].length() && text.startsWith(TemplateConstants.LITERAL[0])) {
            if (!text.endsWith(TemplateConstants.LITERAL[1])) {
                throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.InvalidLitteral"), script, limits);
            }
            String value = text.substring(TemplateConstants.LITERAL[0].length(), text.length() - TemplateConstants.LITERAL[1].length());
            expression = new TemplateLiteralExpression(Conventions.unformatString(value), script);
        } else if (text.equals(LITERAL_TRUE)) {
            expression = new TemplateLiteralExpression(true, script);
        } else if (text.equals(LITERAL_FALSE)) {
            expression = new TemplateLiteralExpression(false, script);
        } else if (text.equals(LITERAL_NULL)) {
            expression = new TemplateLiteralExpression(script);
        } else if (text.length() > 0 && (text.charAt(0) == '-' || Character.isDigit(text.charAt(0)))) {
            if (text.indexOf(".") > -1) {
                try {
                    double value = Double.parseDouble(text);
                    expression = new TemplateLiteralExpression(value, script);
                }
                catch (NumberFormatException numberFormatException) {
                    expression = null;
                }
            } else {
                try {
                    int value = Integer.parseInt(text);
                    expression = new TemplateLiteralExpression(value, script);
                }
                catch (NumberFormatException numberFormatException) {
                    expression = null;
                }
            }
        } else {
            expression = null;
        }
        if (expression != null) {
            expression.setPos(limits);
        }
        return expression;
    }
}

