/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.expressions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.expressions.ExpressionTools;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;

public class TemplateOperatorExpression
extends TemplateExpression {
    protected String operator;
    protected List children = new ArrayList();

    public TemplateOperatorExpression(String operator, IScript script) {
        super(script);
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public void addChild(TemplateExpression expression) {
        this.children.add(expression);
        expression.setParent(this);
    }

    @Override
    public ENode evaluate(ENode current, IScript script, LaunchManager mode) throws ENodeException, FactoryException {
        try {
            Iterator children = this.children.iterator();
            ENode last = null;
            while (children.hasNext()) {
                TemplateExpression child = (TemplateExpression)children.next();
                ENode node = child.evaluate(current, script, mode);
                if (last == null || last.isBoolean()) {
                    if (this.operator.equals(TemplateConstants.OPERATOR_OR)) {
                        if (node.isBoolean() && node.getBoolean()) {
                            last = node;
                            break;
                        }
                    } else if (this.operator.equals(TemplateConstants.OPERATOR_AND) && node.isBoolean() && !node.getBoolean()) {
                        last = node;
                        break;
                    }
                }
                if (last != null) {
                    if (this.operator.equals(TemplateConstants.OPERATOR_OR)) {
                        node = ExpressionTools.or(last, node);
                    } else if (this.operator.equals(TemplateConstants.OPERATOR_AND)) {
                        node = ExpressionTools.and(last, node);
                    } else if (this.operator.equals(TemplateConstants.OPERATOR_EQUALS)) {
                        node = ExpressionTools.equals(last, node);
                    } else if (this.operator.equals(TemplateConstants.OPERATOR_NOT_EQUALS)) {
                        node = ExpressionTools.notEquals(last, node);
                    } else if (this.operator.equals(TemplateConstants.OPERATOR_SUP_EQUALS)) {
                        node = ExpressionTools.supE(last, node);
                    } else if (this.operator.equals(TemplateConstants.OPERATOR_INF_EQUALS)) {
                        node = ExpressionTools.infE(last, node);
                    } else if (this.operator.equals(TemplateConstants.OPERATOR_SUP)) {
                        node = ExpressionTools.sup(last, node);
                    } else if (this.operator.equals(TemplateConstants.OPERATOR_INF)) {
                        node = ExpressionTools.inf(last, node);
                    } else if (this.operator.equals(TemplateConstants.OPERATOR_ADD)) {
                        node = ExpressionTools.add(last, node);
                    } else if (this.operator.equals(TemplateConstants.OPERATOR_SUB)) {
                        node = ExpressionTools.sub(last, node);
                    } else if (this.operator.equals(TemplateConstants.OPERATOR_DIV)) {
                        node = ExpressionTools.div(last, node);
                    } else if (this.operator.equals(TemplateConstants.OPERATOR_MUL)) {
                        node = ExpressionTools.mul(last, node);
                    }
                }
                last = node;
            }
            ENode result = last != null ? last : new ENode(ENode.EMPTY, current);
            return result;
        }
        catch (ENodeCastException e) {
            throw new ENodeException(e.getMessage(), this.pos, script, current, true);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("");
        Iterator children = this.children.iterator();
        while (children.hasNext()) {
            TemplateExpression child = (TemplateExpression)children.next();
            buffer.append(child.toString());
            if (!children.hasNext()) continue;
            buffer.append(String.valueOf(' ') + this.operator + ' ');
        }
        return buffer.toString();
    }

    public static TemplateExpression fromString(String buffer, Int2 limits, IScript script) throws TemplateSyntaxException {
        Int2 trim = TextSearch.getDefaultSearch().trim(buffer, limits.b(), limits.e());
        if (trim.b() == -1) {
            throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingElement"), script, limits);
        }
        limits = trim;
        String[] stringArray = TemplateConstants.OPERATORS;
        int n = TemplateConstants.OPERATORS.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            Int2[] positions = TextSearch.getDefaultSearch().splitPositionsIn(buffer, limits.b(), limits.e(), new String[]{element}, false, TemplateConstants.SPEC, TemplateConstants.INHIBS_EXPRESSION);
            if (positions.length > 1) {
                TemplateOperatorExpression expression = new TemplateOperatorExpression(element, script);
                expression.setPos(limits);
                Int2[] int2Array = positions;
                int n3 = positions.length;
                int n4 = 0;
                while (n4 < n3) {
                    Int2 pos = int2Array[n4];
                    expression.addChild(TemplateExpression.fromString(buffer, pos, script));
                    ++n4;
                }
                return expression;
            }
            ++n2;
        }
        return null;
    }
}

