/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import com.ibm.icu.util.Calendar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.history.filter.RevisionLogEntryFilter;
import org.eclipse.team.svn.ui.panel.common.SelectRevisionPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.IValidationManager;
import org.eclipse.team.svn.ui.verifier.IntegerFieldVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.RevisionRangesVerifier;

public class RevisionComposite
extends Composite {
    protected IRepositoryResource selectedResource;
    protected IRepositoryResource baseResource;
    protected SVNRevision defaultRevision;
    protected long currentRevision;
    protected long lastSelectedRevision;
    protected boolean stopOnCopy;
    protected boolean toFilterCurrent;
    protected boolean startFromCopy;
    protected String[] captions;
    protected SVNRevision selectedRevision;
    protected Text revisionField;
    protected Button headRevisionRadioButton;
    protected Button startFromCopyRadioButton;
    protected Button changeRevisionRadioButton;
    protected Button changeRevisionButton;
    protected Button reverseRevisionsButton;
    protected Button dateTimeRadioButton;
    protected DateTime dateField;
    protected DateTime timeField;
    protected boolean reverseRevisions;
    protected IValidationManager validationManager;
    protected boolean checkStyled;
    protected boolean hasDateTime;
    protected SVNRevisionRange[] revisions;

    public RevisionComposite(Composite parent, IValidationManager validationManager, boolean stopOnCopy, String[] captions, SVNRevision defaultRevision, boolean checkStyled) {
        this(parent, validationManager, stopOnCopy, captions, defaultRevision, checkStyled, true);
    }

    public RevisionComposite(Composite parent, IValidationManager validationManager, boolean stopOnCopy, String[] captions, SVNRevision defaultRevision, boolean checkStyled, boolean hasDateTime) {
        super(parent, 0);
        this.stopOnCopy = stopOnCopy;
        this.toFilterCurrent = false;
        this.validationManager = validationManager;
        this.lastSelectedRevision = -1L;
        this.captions = captions;
        this.defaultRevision = defaultRevision;
        this.checkStyled = checkStyled;
        this.hasDateTime = hasDateTime;
        this.createControls();
    }

    public void setBaseResource(IRepositoryResource baseResource) {
        this.baseResource = baseResource;
    }

    public void setFilterCurrent(boolean toFilter) {
        this.toFilterCurrent = toFilter;
    }

    public boolean isReverseRevisions() {
        return this.reverseRevisions;
    }

    public SVNRevision getSelectedRevision() {
        return this.selectedRevision;
    }

    public SVNRevisionRange[] getSelectedRevisions() {
        if (this.revisions[0].from.getKind() == 0) {
            UIMonitorUtility.doTaskNowDefault((IActionOperation)new AbstractActionOperation("Operation_DetectStartRevision", SVNUIMessages.class){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    ISVNConnector proxy = RevisionComposite.this.selectedResource.getRepositoryLocation().acquireSVNProxy();
                    try {
                        SVNLogEntry[] msgs = SVNUtility.logEntries((ISVNConnector)proxy, (SVNEntryReference)SVNUtility.getEntryReference((IRepositoryResource)RevisionComposite.this.selectedResource), (SVNRevision)SVNRevision.fromNumber((long)0L), (SVNRevision)RevisionComposite.this.selectedResource.getSelectedRevision(), (long)(0x40000L | (RevisionComposite.this.startFromCopy ? 131072L : 0L)), (String[])ISVNConnector.EMPTY_LOG_ENTRY_PROPS, (long)1L, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor, null));
                        if (msgs.length > 0) {
                            RevisionComposite.this.revisions[0] = new SVNRevisionRange((SVNRevision)SVNRevision.fromNumber((long)(RevisionComposite.this.startFromCopy & msgs[0].revision > 1L ? msgs[0].revision - 1L : msgs[0].revision)), RevisionComposite.this.revisions[0].to);
                        }
                    }
                    finally {
                        RevisionComposite.this.selectedResource.getRepositoryLocation().releaseSVNProxy(proxy);
                    }
                }
            }, true);
        }
        int i = 0;
        while (i < this.revisions.length) {
            if (this.reverseRevisions ^ (this.revisions[i].from.getKind() == 7 || this.revisions[i].from.getKind() == 1 && this.revisions[i].to.getKind() == 1 && ((SVNRevision.Number)this.revisions[i].from).getNumber() > ((SVNRevision.Number)this.revisions[i].to).getNumber())) {
                this.revisions[i] = new SVNRevisionRange(this.revisions[i].to, this.revisions[i].from);
            }
            ++i;
        }
        this.reorderRevisions(this.reverseRevisions);
        return this.revisions;
    }

    protected void reorderRevisions(final boolean reverseRevisions) {
        Arrays.sort(this.revisions, new Comparator<SVNRevisionRange>(){

            @Override
            public int compare(SVNRevisionRange o1, SVNRevisionRange o2) {
                long rev2;
                long rev1 = ((SVNRevision.Number)o1.from).getNumber();
                int retVal = rev1 == (rev2 = ((SVNRevision.Number)o2.from).getNumber()) ? 0 : (rev1 < rev2 ? -1 : 1);
                return reverseRevisions ? retVal * -1 : retVal;
            }
        });
    }

    public IRepositoryResource getSelectedResource() {
        return this.selectedResource;
    }

    public void addChangeRevisionListener(SelectionListener listener) {
        this.changeRevisionButton.addSelectionListener(listener);
    }

    public void setSelectedResource(IRepositoryResource resource) {
        this.selectedResource = resource;
        if (this.baseResource == null) {
            this.baseResource = resource;
        }
        if (this.selectedResource == null) {
            this.setEnabled(false);
        } else {
            SVNRevision rev = this.selectedResource.getSelectedRevision();
            this.setRevisionValue(rev);
        }
    }

    public void setRevisionValue(SVNRevision rev) {
        if (rev.getKind() == 1) {
            this.selectedRevision = rev;
            this.lastSelectedRevision = ((SVNRevision.Number)this.selectedRevision).getNumber();
            this.revisionField.setText(this.selectedRevision.toString());
            this.headRevisionRadioButton.setSelection(false);
            if (this.checkStyled) {
                this.startFromCopyRadioButton.setSelection(false);
            } else if (this.hasDateTime) {
                this.dateTimeRadioButton.setSelection(false);
            }
            this.changeRevisionRadioButton.setSelection(true);
        } else if (rev.getKind() == 2 && !this.checkStyled && this.hasDateTime) {
            this.selectedRevision = rev;
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(((SVNRevision.Date)rev).getDate());
            this.dateField.setYear(calendar.get(1));
            this.dateField.setMonth(calendar.get(2));
            this.dateField.setDay(calendar.get(5));
            this.timeField.setHours(calendar.get(11));
            this.timeField.setMinutes(calendar.get(12));
            this.timeField.setSeconds(calendar.get(13));
            this.headRevisionRadioButton.setSelection(false);
            this.dateTimeRadioButton.setSelection(true);
            this.changeRevisionRadioButton.setSelection(false);
        } else {
            this.selectedRevision = this.defaultRevision;
            this.lastSelectedRevision = -1L;
            this.revisionField.setText("");
            this.headRevisionRadioButton.setSelection(!this.checkStyled);
            if (this.checkStyled) {
                this.startFromCopyRadioButton.setSelection(true);
            } else if (this.hasDateTime) {
                this.dateTimeRadioButton.setSelection(false);
            }
            this.changeRevisionRadioButton.setSelection(false);
        }
        this.setEnabled(true);
    }

    public long getCurrentRevision() {
        return this.currentRevision;
    }

    public void setCurrentRevision(long currentRevision) {
        this.currentRevision = currentRevision;
    }

    private void createControls() {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group group = new Group((Composite)this, 0);
        group.setText(this.captions == null ? (this.checkStyled ? SVNUIMessages.RevisionComposite_Revisions : SVNUIMessages.RevisionComposite_Revision) : this.captions[0]);
        layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 3;
        group.setLayoutData((Object)data);
        this.headRevisionRadioButton = new Button((Composite)group, 16);
        this.headRevisionRadioButton.setText(this.captions == null ? (this.checkStyled ? SVNUIMessages.RevisionComposite_All : SVNUIMessages.RevisionComposite_HeadRevision) : this.captions[1]);
        data = new GridData();
        data.horizontalSpan = 3;
        this.headRevisionRadioButton.setLayoutData((Object)data);
        this.headRevisionRadioButton.setSelection(!this.checkStyled);
        this.headRevisionRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RevisionComposite.this.validationManager.validateContent();
                if (((Button)e.widget).getSelection()) {
                    RevisionComposite.this.changeRevisionButton.setEnabled(false);
                    RevisionComposite.this.revisionField.setEnabled(false);
                    if (!RevisionComposite.this.checkStyled && RevisionComposite.this.hasDateTime) {
                        RevisionComposite.this.dateField.setEnabled(false);
                        RevisionComposite.this.timeField.setEnabled(false);
                    }
                    RevisionComposite.this.startFromCopy = false;
                    RevisionComposite.this.defaultToRevisions();
                }
                RevisionComposite.this.additionalValidation();
            }
        });
        if (this.checkStyled) {
            this.startFromCopyRadioButton = new Button((Composite)group, 16);
            this.startFromCopyRadioButton.setText(SVNUIMessages.RevisionComposite_StartFromCopy);
            data = new GridData();
            data.horizontalSpan = 3;
            this.startFromCopyRadioButton.setLayoutData((Object)data);
            this.startFromCopy = true;
            this.startFromCopyRadioButton.setSelection(true);
            this.startFromCopyRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RevisionComposite.this.validationManager.validateContent();
                    if (((Button)e.widget).getSelection()) {
                        RevisionComposite.this.changeRevisionButton.setEnabled(false);
                        RevisionComposite.this.revisionField.setEnabled(false);
                        if (!RevisionComposite.this.checkStyled && RevisionComposite.this.hasDateTime) {
                            RevisionComposite.this.dateField.setEnabled(false);
                            RevisionComposite.this.timeField.setEnabled(false);
                        }
                        RevisionComposite.this.startFromCopy = true;
                        RevisionComposite.this.defaultToRevisions();
                    }
                    RevisionComposite.this.additionalValidation();
                }
            });
        } else if (this.hasDateTime) {
            this.dateTimeRadioButton = new Button((Composite)group, 16);
            this.dateTimeRadioButton.setText(SVNUIMessages.RevisionComposite_DateTime);
            data = new GridData();
            this.dateTimeRadioButton.setLayoutData((Object)data);
            this.dateTimeRadioButton.setSelection(false);
            this.dateTimeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RevisionComposite.this.validationManager.validateContent();
                    if (((Button)e.widget).getSelection()) {
                        RevisionComposite.this.changeRevisionButton.setEnabled(false);
                        RevisionComposite.this.revisionField.setEnabled(false);
                        RevisionComposite.this.dateField.setEnabled(true);
                        RevisionComposite.this.timeField.setEnabled(true);
                        RevisionComposite.this.startFromCopy = false;
                        RevisionComposite.this.dateTimeToRevision();
                    }
                    RevisionComposite.this.additionalValidation();
                }
            });
            Composite cmp = new Composite((Composite)group, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cmp.setLayout((Layout)layout);
            data = new GridData();
            cmp.setLayoutData((Object)data);
            this.dateField = new DateTime(cmp, 65568);
            data = new GridData();
            this.dateField.setLayoutData((Object)data);
            this.dateField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RevisionComposite.this.dateTimeToRevision();
                }
            });
            this.timeField = new DateTime(cmp, 65664);
            data = new GridData();
            this.timeField.setLayoutData((Object)data);
            this.timeField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RevisionComposite.this.dateTimeToRevision();
                }
            });
            Label label = new Label((Composite)group, 0);
            data = new GridData();
            label.setLayoutData((Object)data);
            this.dateField.setEnabled(false);
            this.timeField.setEnabled(false);
        }
        this.changeRevisionRadioButton = new Button((Composite)group, 16);
        this.changeRevisionRadioButton.setText(this.checkStyled ? SVNUIMessages.RevisionComposite_RevisionsCtrl : SVNUIMessages.RevisionComposite_RevisionCtrl);
        this.changeRevisionRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RevisionComposite.this.validationManager.validateContent();
                if (((Button)e.widget).getSelection()) {
                    RevisionComposite.this.changeRevisionButton.setEnabled(true);
                    RevisionComposite.this.revisionField.setEnabled(true);
                    if (!RevisionComposite.this.checkStyled && RevisionComposite.this.hasDateTime) {
                        RevisionComposite.this.dateField.setEnabled(false);
                        RevisionComposite.this.timeField.setEnabled(false);
                    }
                    RevisionComposite.this.startFromCopy = false;
                    RevisionComposite.this.textToRevisions();
                }
                RevisionComposite.this.additionalValidation();
            }
        });
        if (this.checkStyled) {
            data = new GridData(768);
        } else {
            data = new GridData();
            data.horizontalAlignment = 4;
        }
        this.revisionField = new Text((Composite)group, 2052);
        this.revisionField.setLayoutData((Object)data);
        this.revisionField.setEnabled(false);
        CompositeVerifier verifier = new CompositeVerifier();
        String name = this.changeRevisionRadioButton.getText();
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(this.checkStyled ? new RevisionRangesVerifier(name) : new IntegerFieldVerifier(name, true));
        this.validationManager.attachTo((Control)this.revisionField, new AbstractVerifierProxy(verifier){

            protected boolean isVerificationEnabled(Control input) {
                return RevisionComposite.this.changeRevisionRadioButton.getSelection();
            }
        });
        this.revisionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RevisionComposite.this.textToRevisions();
            }
        });
        this.changeRevisionButton = new Button((Composite)group, 8);
        this.changeRevisionButton.setText(SVNUIMessages.Button_Browse);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.changeRevisionButton);
        this.changeRevisionButton.setLayoutData((Object)data);
        this.changeRevisionButton.setEnabled(false);
        this.changeRevisionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetLogMessagesOperation msgsOp = SelectRevisionPanel.getMsgsOp(RevisionComposite.this.selectedResource, RevisionComposite.this.stopOnCopy);
                if (!UIMonitorUtility.doTaskNowDefault(RevisionComposite.this.getShell(), (IActionOperation)msgsOp, true).isCancelled() && msgsOp.getExecutionState() == 0) {
                    DefaultDialog dialog;
                    SelectRevisionPanel panel = new SelectRevisionPanel(msgsOp, RevisionComposite.this.checkStyled, RevisionComposite.this.checkStyled, RevisionComposite.this.currentRevision);
                    if (RevisionComposite.this.toFilterCurrent) {
                        RevisionLogEntryFilter revFilter = new RevisionLogEntryFilter();
                        long revNum = -1L;
                        if (RevisionComposite.this.baseResource != null) {
                            try {
                                revNum = RevisionComposite.this.baseResource.getRevision();
                            }
                            catch (SVNConnectorException sVNConnectorException) {}
                        }
                        revFilter.setRevisionstoHide(revNum, revNum);
                        panel.addFilter(revFilter);
                    }
                    if ((dialog = new DefaultDialog(RevisionComposite.this.getShell(), panel)).open() == 0) {
                        if (RevisionComposite.this.checkStyled) {
                            RevisionComposite.this.revisions = panel.getSelectedRevisions();
                            RevisionComposite.this.reorderRevisions(false);
                            String text = "";
                            SVNRevisionRange[] sVNRevisionRangeArray = RevisionComposite.this.revisions;
                            int n = RevisionComposite.this.revisions.length;
                            int n2 = 0;
                            while (n2 < n) {
                                SVNRevisionRange range = sVNRevisionRangeArray[n2];
                                text = String.valueOf(text) + (text.length() == 0 ? range.toString() : ", " + range.toString());
                                ++n2;
                            }
                            RevisionComposite.this.revisionField.setText(text);
                        } else {
                            long selectedRevisionNum;
                            RevisionComposite.this.lastSelectedRevision = selectedRevisionNum = panel.getSelectedRevision();
                            RevisionComposite.this.selectedRevision = SVNRevision.fromNumber((long)selectedRevisionNum);
                            RevisionComposite.this.revisionField.setText(String.valueOf(selectedRevisionNum));
                        }
                    }
                }
                RevisionComposite.this.additionalValidation();
            }
        });
        if (this.checkStyled) {
            this.reverseRevisionsButton = new Button((Composite)group, 32);
            this.reverseRevisionsButton.setText(SVNUIMessages.RevisionComposite_Reverse);
            data = new GridData(768);
            data.horizontalSpan = 2;
            this.reverseRevisionsButton.setLayoutData((Object)data);
            this.reverseRevisionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RevisionComposite.this.reverseRevisions = ((Button)e.widget).getSelection();
                }
            });
        }
        this.defaultToRevisions();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.headRevisionRadioButton.setEnabled(enabled);
        if (this.checkStyled) {
            this.startFromCopyRadioButton.setEnabled(enabled);
            this.reverseRevisionsButton.setEnabled(enabled);
        } else if (this.hasDateTime) {
            this.dateTimeRadioButton.setEnabled(enabled);
            this.dateField.setEnabled(enabled && this.dateTimeRadioButton.getSelection());
            this.timeField.setEnabled(enabled && this.dateTimeRadioButton.getSelection());
        }
        this.changeRevisionRadioButton.setEnabled(enabled);
        this.changeRevisionButton.setEnabled(enabled && this.changeRevisionRadioButton.getSelection());
        this.revisionField.setEnabled(enabled && this.changeRevisionRadioButton.getSelection());
    }

    public void additionalValidation() {
    }

    protected void dateTimeToRevision() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.dateField.getYear(), this.dateField.getMonth(), this.dateField.getDay(), this.timeField.getHours(), this.timeField.getMinutes(), this.timeField.getSeconds());
        this.selectedRevision = SVNRevision.fromDate((long)calendar.getTimeInMillis());
    }

    protected void defaultToRevisions() {
        if (this.checkStyled) {
            this.revisions = new SVNRevisionRange[]{new SVNRevisionRange(SVNRevision.START, this.defaultRevision)};
        } else {
            this.selectedRevision = this.defaultRevision;
        }
    }

    protected void textToRevisions() {
        String input = this.revisionField.getText();
        try {
            if (this.checkStyled) {
                String[] parts = input.split(",");
                ArrayList<SVNRevisionRange> revisions = new ArrayList<SVNRevisionRange>();
                String[] stringArray = parts;
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    revisions.add(new SVNRevisionRange(part.trim()));
                    ++n2;
                }
                this.revisions = revisions.toArray(new SVNRevisionRange[revisions.size()]);
            } else {
                long selectedRevisionNum = Long.parseLong(input);
                if (selectedRevisionNum >= 0L) {
                    this.lastSelectedRevision = selectedRevisionNum;
                    this.selectedRevision = SVNRevision.fromNumber((long)selectedRevisionNum);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }
}

