/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.createpatch;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.local.SavePatchInWorkspacePanel;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.ResourcePathVerifier;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectPatchFilePage
extends AbstractVerifiedWizardPage {
    protected Text fileNameField;
    protected Text wsPathField;
    protected Button browseButton;
    protected Button browseWSButton;
    protected String proposedName;
    protected String fileName;
    protected IFile file;
    protected int writeMode;
    protected CheckboxTreeViewer changeViewer;
    protected IResource[] roots;
    protected Object[] initialSelection;
    protected Object[] realSelection;

    public SelectPatchFilePage(String proposedName, IResource[] roots) {
        super(SelectPatchFilePage.class.getName(), SVNUIMessages.SelectPatchFilePage_Title, SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.setDescription(SVNUIMessages.SelectPatchFilePage_Description);
        this.proposedName = String.valueOf(proposedName) + ".patch";
        this.writeMode = 0;
        this.roots = roots;
        try {
            File tmp = File.createTempFile("patch", "tmp");
            tmp.delete();
            this.fileName = tmp.getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRecursive() {
        if (this.initialSelection == null) {
            return true;
        }
        HashSet<Object> result = new HashSet<Object>(Arrays.asList(this.initialSelection));
        result.removeAll(Arrays.asList(this.realSelection));
        return result.isEmpty();
    }

    public IResource[] getSelection() {
        return Arrays.asList(this.realSelection).toArray(new IResource[this.realSelection.length]);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getWriteMode() {
        return this.writeMode;
    }

    protected Composite createControlImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Composite saveTo = composite;
        if (this.roots != null) {
            Group saveToImpl = new Group(composite, 0);
            layout = new GridLayout();
            saveToImpl.setLayout((Layout)layout);
            data = new GridData(768);
            saveToImpl.setLayoutData((Object)data);
            saveToImpl.setText(SVNUIMessages.SelectPatchFilePage_SaveTo);
            saveTo = saveToImpl;
        }
        Button saveToClipboard = new Button(saveTo, 16);
        saveToClipboard.setText(SVNUIMessages.SelectPatchFilePage_SaveToClipboard);
        data = new GridData(768);
        saveToClipboard.setLayoutData((Object)data);
        saveToClipboard.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    SelectPatchFilePage.this.fileNameField.setEnabled(false);
                    SelectPatchFilePage.this.browseButton.setEnabled(false);
                    SelectPatchFilePage.this.browseWSButton.setEnabled(false);
                    try {
                        SelectPatchFilePage.this.fileName = File.createTempFile("patch", ".tmp").getAbsolutePath();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    SelectPatchFilePage.this.writeMode = 0;
                    SelectPatchFilePage.this.validateContent();
                }
            }
        });
        final Button saveOnFileSystem = new Button(saveTo, 16);
        saveOnFileSystem.setText(SVNUIMessages.SelectPatchFilePage_SaveInFS);
        data = new GridData(768);
        saveOnFileSystem.setLayoutData((Object)data);
        saveOnFileSystem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    SelectPatchFilePage.this.fileNameField.setEnabled(true);
                    SelectPatchFilePage.this.browseButton.setEnabled(true);
                    SelectPatchFilePage.this.browseWSButton.setEnabled(false);
                    SelectPatchFilePage.this.fileName = SelectPatchFilePage.this.fileNameField.getText();
                    SelectPatchFilePage.this.writeMode = 1;
                    SelectPatchFilePage.this.validateContent();
                }
            }
        });
        Composite fsComposite = new Composite(saveTo, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        fsComposite.setLayout((Layout)layout);
        data = new GridData(768);
        fsComposite.setLayoutData((Object)data);
        this.fileNameField = new Text(fsComposite, 2052);
        data = new GridData(768);
        this.fileNameField.setLayoutData((Object)data);
        this.fileNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectPatchFilePage.this.fileName = SelectPatchFilePage.this.fileNameField.getText();
            }
        });
        CompositeVerifier cVerifier = new CompositeVerifier();
        String name = SVNUIMessages.SelectPatchFilePage_SaveInFS_Verifier;
        cVerifier.add(new NonEmptyFieldVerifier(name));
        cVerifier.add(new ResourcePathVerifier(name));
        cVerifier.add(new AbstractFormattedVerifier(name){

            protected String getErrorMessageImpl(Control input) {
                return null;
            }

            protected String getWarningMessageImpl(Control input) {
                String text = this.getText(input);
                if (new File(text).exists()) {
                    return SVNUIMessages.format((String)SVNUIMessages.SelectPatchFilePage_SaveInFS_Verifier_Warning, (Object[])new String[]{"$FIELD_NAME$"});
                }
                return null;
            }
        });
        this.attachTo((Control)this.fileNameField, new AbstractVerifierProxy(cVerifier){

            protected boolean isVerificationEnabled(Control input) {
                return saveOnFileSystem.getSelection();
            }
        });
        this.browseButton = new Button(fsComposite, 8);
        this.browseButton.setText(SVNUIMessages.Button_Browse);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.browseButton);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog dlg = new FileDialog(SelectPatchFilePage.this.getShell(), 40960);
                dlg.setText(SVNUIMessages.SelectPatchFilePage_SavePatchAs);
                dlg.setFileName(SelectPatchFilePage.this.proposedName);
                dlg.setFilterExtensions(new String[]{"*.patch", "*.*"});
                String file = dlg.open();
                if (file != null) {
                    SelectPatchFilePage.this.fileName = file;
                    SelectPatchFilePage.this.fileNameField.setText(file);
                    SelectPatchFilePage.this.validateContent();
                }
            }
        });
        final Button saveInWorkspace = new Button(saveTo, 16);
        data = new GridData(768);
        saveInWorkspace.setLayoutData((Object)data);
        saveInWorkspace.setText(SVNUIMessages.SelectPatchFilePage_SaveInWS);
        saveInWorkspace.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    SelectPatchFilePage.this.fileNameField.setEnabled(false);
                    SelectPatchFilePage.this.browseButton.setEnabled(false);
                    SelectPatchFilePage.this.browseWSButton.setEnabled(true);
                    SelectPatchFilePage.this.fileName = SelectPatchFilePage.this.file == null ? null : FileUtility.getWorkingCopyPath((IResource)SelectPatchFilePage.this.file);
                    SelectPatchFilePage.this.writeMode = 2;
                    SelectPatchFilePage.this.validateContent();
                }
            }
        });
        Composite wsComposite = new Composite(saveTo, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        wsComposite.setLayout((Layout)layout);
        data = new GridData(768);
        wsComposite.setLayoutData((Object)data);
        this.wsPathField = new Text(wsComposite, 2060);
        data = new GridData(768);
        this.wsPathField.setLayoutData((Object)data);
        cVerifier = new CompositeVerifier();
        name = SVNUIMessages.SelectPatchFilePage_SaveInWS_Verifier;
        cVerifier.add(new NonEmptyFieldVerifier(name));
        cVerifier.add(new AbstractFormattedVerifier(name){

            protected String getErrorMessageImpl(Control input) {
                return null;
            }

            protected String getWarningMessageImpl(Control input) {
                if (SelectPatchFilePage.this.file != null && SelectPatchFilePage.this.file.isAccessible()) {
                    return SVNUIMessages.format((String)SVNUIMessages.SelectPatchFilePage_SaveInWS_Verifier_Warning, (Object[])new String[]{"$FIELD_NAME$"});
                }
                return null;
            }
        });
        this.attachTo((Control)this.wsPathField, new AbstractVerifierProxy(cVerifier){

            protected boolean isVerificationEnabled(Control input) {
                return saveInWorkspace.getSelection();
            }
        });
        this.browseWSButton = new Button(wsComposite, 8);
        this.browseWSButton.setText(SVNUIMessages.Button_Browse);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.browseWSButton);
        this.browseWSButton.setLayoutData((Object)data);
        this.browseWSButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProject proposedDestination = SelectPatchFilePage.this.roots.length > 0 ? SelectPatchFilePage.this.roots[0].getProject() : null;
                SavePatchInWorkspacePanel panel = new SavePatchInWorkspacePanel(SelectPatchFilePage.this.proposedName, proposedDestination);
                DefaultDialog dlg = new DefaultDialog(SelectPatchFilePage.this.getShell(), panel);
                if (dlg.open() == 0) {
                    SelectPatchFilePage.this.file = panel.getFile();
                    SelectPatchFilePage.this.fileName = FileUtility.getWorkingCopyPath((IResource)SelectPatchFilePage.this.file);
                    SelectPatchFilePage.this.wsPathField.setText(SelectPatchFilePage.this.file.getFullPath().toString());
                    SelectPatchFilePage.this.validateContent();
                }
            }
        });
        if (this.roots != null) {
            Label label = new Label(composite, 0);
            data = new GridData();
            label.setLayoutData((Object)data);
            label.setText(SVNUIMessages.SelectPatchFilePage_Changes);
            this.changeViewer = new CheckboxTreeViewer(composite, 2048);
            data = new GridData(1808);
            data.heightHint = 200;
            data.widthHint = 600;
            this.changeViewer.getControl().setLayoutData((Object)data);
            this.changeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

                public Object[] getChildren(Object element) {
                    Object[] result;
                    if (element instanceof IProject || element instanceof IFolder) {
                        try {
                            IResource[] result2 = SVNRemoteStorage.instance().getRegisteredChildren((IContainer)element);
                            return result2 != null ? result2 : new Object[]{};
                        }
                        catch (Exception exception) {}
                    }
                    return (result = super.getChildren(element)) != null ? result : new Object[]{};
                }
            });
            this.changeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.changeViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    SelectPatchFilePage.this.changeViewer.getControl().setRedraw(false);
                    IResource resource = (IResource)event.getElement();
                    HashSet<Object> grayed = new HashSet<Object>();
                    grayed.addAll(Arrays.asList(SelectPatchFilePage.this.changeViewer.getGrayedElements()));
                    if (event.getChecked()) {
                        if (resource.getType() != 1) {
                            SelectPatchFilePage.this.changeViewer.setSubtreeChecked((Object)resource, true);
                            IPath path = resource.getFullPath();
                            int i = 0;
                            while (i < SelectPatchFilePage.this.initialSelection.length) {
                                IResource current = (IResource)SelectPatchFilePage.this.initialSelection[i];
                                if (path.isPrefixOf(current.getFullPath())) {
                                    grayed.remove(current);
                                }
                                ++i;
                            }
                        }
                        while ((resource = resource.getParent()).getType() != 8) {
                            boolean hasUnchecked = false;
                            IPath path = resource.getFullPath();
                            int i = 0;
                            while (i < SelectPatchFilePage.this.initialSelection.length) {
                                IResource current = (IResource)SelectPatchFilePage.this.initialSelection[i];
                                if (path.isPrefixOf(current.getFullPath()) && !current.equals((Object)resource)) {
                                    hasUnchecked |= !SelectPatchFilePage.this.changeViewer.getChecked((Object)current);
                                }
                                ++i;
                            }
                            if (hasUnchecked) continue;
                            grayed.remove(resource);
                            SelectPatchFilePage.this.changeViewer.setChecked((Object)resource, true);
                        }
                    } else {
                        if (resource.getType() != 1) {
                            SelectPatchFilePage.this.changeViewer.setSubtreeChecked((Object)resource, false);
                        }
                        grayed.addAll(Arrays.asList(FileUtility.getPathNodes((IResource)resource)));
                    }
                    SelectPatchFilePage.this.changeViewer.setGrayedElements(grayed.toArray());
                    SelectPatchFilePage.this.realSelection = SelectPatchFilePage.this.changeViewer.getCheckedElements();
                    SelectPatchFilePage.this.changeViewer.getControl().setRedraw(true);
                }
            });
            this.changeViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof IResource) {
                        IResource resource = (IResource)element;
                        IPath resourcePath = resource.getFullPath();
                        int i = 0;
                        while (i < SelectPatchFilePage.this.roots.length) {
                            IPath rootPath = SelectPatchFilePage.this.roots[i].getFullPath();
                            if ((rootPath.isPrefixOf(resourcePath) || resourcePath.isPrefixOf(rootPath)) && FileUtility.checkForResourcesPresenceRecursive((IResource[])new IResource[]{resource}, (IStateFilter)IStateFilter.SF_ANY_CHANGE)) {
                                return true;
                            }
                            ++i;
                        }
                    }
                    return false;
                }
            });
            this.changeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            this.changeViewer.expandAll();
            TreeItem[] items = this.changeViewer.getTree().getItems();
            int i = 0;
            while (i < items.length) {
                this.changeViewer.setSubtreeChecked(items[i].getData(), true);
                ++i;
            }
            this.initialSelection = this.changeViewer.getCheckedElements();
            this.realSelection = this.initialSelection;
        }
        this.fileNameField.setEnabled(false);
        this.browseButton.setEnabled(false);
        this.browseWSButton.setEnabled(false);
        saveToClipboard.setSelection(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.svn.help.patchFileContext");
        return composite;
    }
}

