/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.listeners;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.TreePackage;
import org.eclipse.sirius.ui.tools.internal.editor.ChangeExpandeStateRunnable;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class DTreeItemExpansionChecker
implements Listener {
    private IPermissionAuthority permissionAuthority;
    private Control control;

    public DTreeItemExpansionChecker(Control control, IPermissionAuthority permissionAuthority) {
        this.control = control;
        this.permissionAuthority = permissionAuthority;
        control.getDisplay().addFilter(17, (Listener)this);
        control.getDisplay().addFilter(18, (Listener)this);
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 18: {
                this.handleTreeCollapse(event);
                break;
            }
            case 17: {
                this.handleTreeExpand(event);
                break;
            }
        }
    }

    private void handleTreeCollapse(Event event) {
        if (!this.isEventForDTreeItemExpandable(event)) {
            event.type = 0;
            TreeItem treeItem = (TreeItem)event.item;
            Display.getDefault().asyncExec((Runnable)new ChangeExpandeStateRunnable(treeItem, true));
        }
    }

    private void handleTreeExpand(Event event) {
        if (!this.isEventForDTreeItemExpandable(event)) {
            event.type = 0;
            TreeItem treeItem = (TreeItem)event.item;
            Display.getDefault().asyncExec((Runnable)new ChangeExpandeStateRunnable(treeItem, false));
        }
    }

    private boolean isEventForDTreeItemExpandable(Event event) {
        TreeItem treeItem;
        Object data;
        boolean isEventForDTreeItemExpandable = true;
        if (event.item instanceof TreeItem && (data = (treeItem = (TreeItem)event.item).getData()) instanceof DTreeItem) {
            boolean canEditFeature;
            DTreeItem dTreeItem = (DTreeItem)data;
            isEventForDTreeItemExpandable = canEditFeature = this.permissionAuthority != null && this.permissionAuthority.canEditFeature((EObject)dTreeItem, TreePackage.Literals.DTREE_ITEM__EXPANDED.getName());
        }
        return isEventForDTreeItemExpandable;
    }

    public void dispose() {
        this.control.getDisplay().removeFilter(17, (Listener)this);
        this.control.getDisplay().removeFilter(18, (Listener)this);
        this.permissionAuthority = null;
        this.control = null;
    }
}

