/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.listeners;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.command.DTreeItemExpansionChangeCommand;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.business.internal.helper.RefreshTreeElementTask;

public class DTreeViewerListener
implements ITreeViewerListener {
    private Session session;

    public DTreeViewerListener(Session session) {
        this.session = session;
    }

    public void treeExpanded(TreeExpansionEvent event) {
        DTreeItem dTreeItem;
        if (event.getElement() instanceof DTreeItem && !(dTreeItem = (DTreeItem)event.getElement()).isExpanded()) {
            TransactionalEditingDomain domain = this.session.getTransactionalEditingDomain();
            CommandStack commandStack = domain.getCommandStack();
            CompoundCommand expandDTreeItemCmd = new CompoundCommand("Expand " + dTreeItem.getName() + " tree item");
            GlobalContext globalContext = new GlobalContext(this.session.getModelAccessor(), this.session.getInterpreter(), this.session.getSemanticResources());
            expandDTreeItemCmd.append((Command)new DTreeItemExpansionChangeCommand(globalContext, domain, dTreeItem, true));
            if (!Platform.getPreferencesService().getBoolean("org.eclipse.sirius", SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), false, null)) {
                SiriusCommand result = new SiriusCommand(domain);
                result.getTasks().add(new RefreshTreeElementTask((EObject)((DTreeItem)event.getElement()), domain));
                expandDTreeItemCmd.append((Command)result);
            }
            commandStack.execute((Command)expandDTreeItemCmd);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        DTreeItem dTreeItem;
        if (event.getElement() instanceof DTreeItem && (dTreeItem = (DTreeItem)event.getElement()).isExpanded()) {
            TransactionalEditingDomain domain = this.session.getTransactionalEditingDomain();
            CommandStack commandStack = domain.getCommandStack();
            GlobalContext globalContext = new GlobalContext(this.session.getModelAccessor(), this.session.getInterpreter(), this.session.getSemanticResources());
            DTreeItemExpansionChangeCommand collapseDTreeItemCmd = new DTreeItemExpansionChangeCommand(globalContext, domain, dTreeItem, false);
            commandStack.execute((Command)collapseDTreeItemCmd);
        }
    }
}

