/*
 * Decompiled with CFR 0.152.
 */
package eu.merge.project.process.scenario;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BinaryOperator implements Enumerator
{
    AND(0, "AND", "AND"),
    OR(0, "OR", "OR"),
    BELONGS_TO(0, "BELONGS_TO", "BELONGS_TO"),
    EQUALS_TO(0, "EQUALS_TO", "EQUALS_TO"),
    DIFFERENT_FROM(0, "DIFFERENT_FROM", "DIFFERENT_FROM");

    public static final int AND_VALUE = 0;
    public static final int OR_VALUE = 0;
    public static final int BELONGS_TO_VALUE = 0;
    public static final int EQUALS_TO_VALUE = 0;
    public static final int DIFFERENT_FROM_VALUE = 0;
    private static final BinaryOperator[] VALUES_ARRAY;
    public static final List<BinaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BinaryOperator[]{AND, OR, BELONGS_TO, EQUALS_TO, DIFFERENT_FROM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BinaryOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryOperator get(int value) {
        switch (value) {
            case 0: {
                return AND;
            }
        }
        return null;
    }

    private BinaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

