/*
 * Decompiled with CFR 0.152.
 */
package eu.merge.project.process.scenario;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum UnaryOperator implements Enumerator
{
    NOT(0, "NOT", "NOT"),
    EXIST(0, "EXIST", "EXIST"),
    TRUE(0, "TRUE", "TRUE"),
    FALSE(0, "FALSE", "FALSE");

    public static final int NOT_VALUE = 0;
    public static final int EXIST_VALUE = 0;
    public static final int TRUE_VALUE = 0;
    public static final int FALSE_VALUE = 0;
    private static final UnaryOperator[] VALUES_ARRAY;
    public static final List<UnaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UnaryOperator[]{NOT, EXIST, TRUE, FALSE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UnaryOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnaryOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnaryOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnaryOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnaryOperator get(int value) {
        switch (value) {
            case 0: {
                return NOT;
            }
        }
        return null;
    }

    private UnaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

