/*
 * Decompiled with CFR 0.152.
 */
package eu.merge.project.processmodeler.dashboard.action;

import eu.merge.project.process.scenario.Diagram;
import eu.merge.project.processmodeler.dashboard.editor.DashboardEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ShowDashboardAction
implements IObjectActionDelegate {
    public Diagram diagram;
    public URI fileUri;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                Session session = ShowDashboardAction.this.getSession();
                ShowDashboardAction.this.diagram = ShowDashboardAction.this.getScenarioDiagram(session);
                try {
                    activePage.openEditor((IEditorInput)new DashboardEditorInput(session, ShowDashboardAction.this.diagram), "obeo.processmodeler.dashboard.editor.DashboardEditor");
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Display display = Display.getCurrent();
        if (display == null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IFile file = (IFile)((IStructuredSelection)selection).getFirstElement();
        if (file != null) {
            this.fileUri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        }
    }

    private Diagram getScenarioDiagram(Session session) {
        for (Resource semanticResource : session.getSemanticResources()) {
            for (EObject eObject : semanticResource.getContents()) {
                if (!(eObject instanceof Diagram)) continue;
                return (Diagram)eObject;
            }
        }
        return null;
    }

    private Session getSession() {
        for (Session aSession : SessionManager.INSTANCE.getSessions()) {
            for (Resource semanticResource : aSession.getSemanticResources()) {
                if (!semanticResource.getURI().equals(this.fileUri)) continue;
                return aSession;
            }
        }
        return null;
    }
}

