/*
 * Decompiled with CFR 0.152.
 */
package eu.merge.project.processmodeler.dashboard.pages;

import eu.merge.project.process.scenario.Activity;
import eu.merge.project.process.scenario.AddActivity;
import eu.merge.project.process.scenario.CreateActivity;
import eu.merge.project.process.scenario.Diagram;
import eu.merge.project.process.scenario.ExportActivity;
import eu.merge.project.process.scenario.FinalActivity;
import eu.merge.project.process.scenario.ImportActivity;
import eu.merge.project.process.scenario.InitialActivity;
import eu.merge.project.process.scenario.Process;
import eu.merge.project.process.scenario.RemoveActivity;
import eu.merge.project.process.scenario.SelectActivity;
import eu.merge.project.process.scenario.SetActivity;
import eu.merge.project.process.scenario.Transition;
import eu.merge.project.process.scenario.ValidateActivity;
import eu.merge.project.processmodeler.dashboard.Activator;
import eu.merge.project.processmodeler.dashboard.editor.DashboardEditor;
import eu.merge.project.processmodeler.dashboard.pages.AbstractDashboardPage;
import eu.merge.project.processmodeler.dashboard.util.DashboardPageMap;
import eu.merge.project.processmodeler.dashboard.util.DashboardSectionMap;
import eu.merge.project.processmodeler.dashboard.util.FormTextPageLinkAdapter;
import eu.merge.project.processmodeler.dashboard.wizards.DashboardWizard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class DashboardMainPage
extends AbstractDashboardPage {
    private static Map<String, String> __hrefImageMappings = new HashMap<String, String>();
    private static Map<String, String> __hoverHrefImageMappings = new HashMap<String, String>();
    static DashboardEditor editor;
    Diagram diagram;

    public DashboardMainPage(DashboardEditor editor_p) {
        super((FormEditor)editor_p, DashboardMainPage.class.getName(), "Main page");
        editor = editor_p;
        this.diagram = editor.getEditorInput().getDiagram();
    }

    @Override
    protected void createFormContent(IManagedForm managedForm_p) {
        super.createFormContent(managedForm_p);
        ScrolledForm form = managedForm_p.getForm();
        form.setText("Processes");
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        Composite body = form.getBody();
        body.setLayout((Layout)layout);
        Activator activator = Activator.getDefault();
        FormToolkit toolkit = managedForm_p.getToolkit();
        TableWrapData layoutData = new TableWrapData();
        layoutData.align = 4;
        layoutData.valign = 32;
        this.createProcessSection(managedForm_p, body, (EObject)this.diagram, activator, toolkit);
    }

    private void createProcessSection(IManagedForm managedForm_p, Composite body, EObject diagram, Activator activator, FormToolkit toolkit) {
        for (EObject content : diagram.eContents()) {
            if (!(content instanceof Process)) continue;
            Composite subsection = null;
            if (!(content.eContainer() instanceof Process)) {
                Composite composite = this.createSuperProcessSection(body, managedForm_p, toolkit, (Process)content);
                DashboardSectionMap.getInstance().put(content, composite);
            } else if (content.eContainer() instanceof Process) {
                subsection = this.createSuperProcessSection((Composite)DashboardSectionMap.getInstance().get(content.eContainer()), managedForm_p, toolkit, (Process)content);
                DashboardSectionMap.getInstance().put(content, subsection);
            }
            this.createProcessSection(managedForm_p, body, content, activator, toolkit);
            if (this.getFirstActivities(diagram, (Process)content).isEmpty()) continue;
            for (Activity activity : this.getFirstActivities(diagram, (Process)content)) {
                DashboardMainPage.getActivitiesImages(managedForm_p, (Composite)DashboardSectionMap.getInstance().get((Process)content), activator, activity);
            }
        }
    }

    public static void getActivitiesImages(IManagedForm managedForm_p, final Composite parent, Activator activator, final Activity activity) {
        String name;
        ImageHyperlink imageHL = managedForm_p.getToolkit().createImageHyperlink(parent, 0);
        if (!(activity instanceof InitialActivity) && !(activity instanceof FinalActivity)) {
            if (activity instanceof CreateActivity) {
                imageHL.setImage(activator.getImage("full/Create.png"));
                imageHL.setHoverImage(activator.getImage("full/Create_Hover.png"));
            } else if (activity instanceof AddActivity) {
                imageHL.setImage(activator.getImage("full/Add.png"));
                imageHL.setHoverImage(activator.getImage("full/Add_Hover.png"));
            } else if (activity instanceof RemoveActivity) {
                imageHL.setImage(activator.getImage("full/Remove.png"));
                imageHL.setHoverImage(activator.getImage("full/Remove_Hover.png"));
            } else if (activity instanceof ImportActivity) {
                imageHL.setImage(activator.getImage("full/Import.png"));
                imageHL.setHoverImage(activator.getImage("full/Import_Hover.png"));
            } else if (activity instanceof ExportActivity) {
                imageHL.setImage(activator.getImage("full/Export.png"));
                imageHL.setHoverImage(activator.getImage("full/Export_Hover.png"));
            } else if (activity instanceof SetActivity) {
                imageHL.setImage(activator.getImage("full/Set.png"));
                imageHL.setHoverImage(activator.getImage("full/Set_Hover.png"));
            } else if (activity instanceof SelectActivity) {
                imageHL.setImage(activator.getImage("full/Select.png"));
                imageHL.setHoverImage(activator.getImage("full/Select_Hover.png"));
            } else if (activity instanceof ValidateActivity) {
                imageHL.setImage(activator.getImage("full/Validate.png"));
                imageHL.setHoverImage(activator.getImage("full/Validate_Hover.png"));
            }
        }
        if ((name = activity.getName()) == null) {
            name = "";
        }
        imageHL.setText(name);
        MouseListener listener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                WizardDialog wizardDialog = new WizardDialog(parent.getShell(), (IWizard)new DashboardWizard(activity));
                wizardDialog.open();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        imageHL.addMouseListener(listener);
    }

    protected Composite createSuperProcessSection(Composite sectionContainer_p, IManagedForm managedForm_p, FormToolkit toolkit, Process process) {
        Section section = toolkit.createSection(sectionContainer_p, 386);
        section.setExpanded(true);
        section.setText(process.getName());
        Composite sectionClient = toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new GridLayout());
        section.setClient((Control)sectionClient);
        return sectionClient;
    }

    private List<Activity> getFirstActivities(EObject diagram, Process process) {
        if (process.getActivities() != null) {
            for (Activity activity : process.getActivities()) {
                if (!(activity instanceof InitialActivity)) continue;
                return DashboardMainPage.getNextActivities(diagram, activity);
            }
        }
        return new ArrayList<Activity>();
    }

    static List<Activity> getNextActivities(EObject diagram, Activity activity) {
        ArrayList<Activity> activites = new ArrayList<Activity>();
        List<Transition> transitions = DashboardMainPage.getActivityTransitions(diagram, activity);
        for (Transition transition : transitions) {
            if (transition.getEnd() instanceof FinalActivity) continue;
            activites.add(transition.getEnd());
        }
        return activites;
    }

    private static List<Transition> getActivityTransitions(EObject diagram, Activity activity) {
        TreeIterator contents = diagram.eAllContents();
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        while (contents.hasNext()) {
            EObject transition = (EObject)contents.next();
            if (!(transition instanceof Transition) || ((Transition)transition).getStart() != activity) continue;
            transitions.add((Transition)transition);
        }
        return transitions;
    }

    private static IFormPage getActivityPage(DashboardPageMap map, Activity activity) {
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() != activity) continue;
            return (IFormPage)entry.getValue();
        }
        return null;
    }

    class MainPageLinkAdapter
    extends FormTextPageLinkAdapter {
        public MainPageLinkAdapter(FormEditor editor_p) {
            super(editor_p);
        }

        @Override
        public void linkEntered(HyperlinkEvent e_p) {
            super.linkEntered(e_p);
            this.updateImage(e_p, __hoverHrefImageMappings);
        }

        @Override
        public void linkExited(HyperlinkEvent e_p) {
            super.linkExited(e_p);
            this.updateImage(e_p, __hrefImageMappings);
        }

        private void updateImage(HyperlinkEvent e_p, Map<String, String> imageMappings_p) {
            String pageId = (String)e_p.getHref();
            String image = imageMappings_p.get(pageId);
            if (image != null) {
                ((FormText)e_p.widget).setImage(pageId, Activator.getDefault().getImage(image));
            }
        }
    }
}

