/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.connector.svnkit;

import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ClientNotifyInformation;
import org.apache.subversion.javahl.ConflictDescriptor;
import org.apache.subversion.javahl.ConflictResult;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.BlameCallback;
import org.apache.subversion.javahl.callback.ClientNotifyCallback;
import org.apache.subversion.javahl.callback.ConflictResolverCallback;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.callback.PatchCallback;
import org.apache.subversion.javahl.callback.ProplistCallback;
import org.apache.subversion.javahl.callback.StatusCallback;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.Checksum;
import org.apache.subversion.javahl.types.ConflictVersion;
import org.apache.subversion.javahl.types.CopySource;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.Mergeinfo;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;
import org.apache.subversion.javahl.types.Status;
import org.eclipse.team.svn.core.connector.ISVNAnnotationCallback;
import org.eclipse.team.svn.core.connector.ISVNConflictResolutionCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryInfoCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNLogEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.ISVNPatchCallback;
import org.eclipse.team.svn.core.connector.ISVNPropertyCallback;
import org.eclipse.team.svn.core.connector.SVNAnnotationData;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNChecksum;
import org.eclipse.team.svn.core.connector.SVNConflictDescriptor;
import org.eclipse.team.svn.core.connector.SVNConflictResolution;
import org.eclipse.team.svn.core.connector.SVNConflictVersion;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNLock;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.core.connector.SVNMergeInfo;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConversionUtility {
    private static Map<ClientNotifyInformation.Action, Integer> notifyInfoActionMap;
    private static Map<ClientNotifyInformation.Status, Integer> notifyInfoStatusMap;
    private static Map<ClientNotifyInformation.LockStatus, Integer> notifyInfoLockStatusMap;
    private static Map<NodeKind, Integer> nodeKindMap;
    private static Map<ConflictDescriptor.Reason, Integer> conflictReasonMap;
    private static Map<Status.Kind, Integer> syncStatusMap;

    static {
        syncStatusMap = new HashMap<Status.Kind, Integer>();
        syncStatusMap.put(Status.Kind.none, 0);
        syncStatusMap.put(Status.Kind.unversioned, 5);
        syncStatusMap.put(Status.Kind.normal, 1);
        syncStatusMap.put(Status.Kind.added, 3);
        syncStatusMap.put(Status.Kind.missing, 6);
        syncStatusMap.put(Status.Kind.deleted, 4);
        syncStatusMap.put(Status.Kind.replaced, 7);
        syncStatusMap.put(Status.Kind.modified, 2);
        syncStatusMap.put(Status.Kind.merged, 8);
        syncStatusMap.put(Status.Kind.conflicted, 9);
        syncStatusMap.put(Status.Kind.ignored, 11);
        syncStatusMap.put(Status.Kind.obstructed, 10);
        syncStatusMap.put(Status.Kind.external, 13);
        syncStatusMap.put(Status.Kind.incomplete, 12);
        conflictReasonMap = new HashMap<ConflictDescriptor.Reason, Integer>();
        conflictReasonMap.put(ConflictDescriptor.Reason.added, 5);
        conflictReasonMap.put(ConflictDescriptor.Reason.deleted, 2);
        conflictReasonMap.put(ConflictDescriptor.Reason.edited, 0);
        conflictReasonMap.put(ConflictDescriptor.Reason.missing, 3);
        conflictReasonMap.put(ConflictDescriptor.Reason.obstructed, 1);
        conflictReasonMap.put(ConflictDescriptor.Reason.unversioned, 4);
        nodeKindMap = new HashMap<NodeKind, Integer>();
        nodeKindMap.put(NodeKind.none, 0);
        nodeKindMap.put(NodeKind.file, 1);
        nodeKindMap.put(NodeKind.dir, 2);
        nodeKindMap.put(NodeKind.unknown, 3);
        notifyInfoStatusMap = new HashMap<ClientNotifyInformation.Status, Integer>();
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.inapplicable, 0);
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.unknown, 1);
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.unchanged, 2);
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.missing, 3);
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.obstructed, 4);
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.changed, 5);
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.merged, 6);
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.conflicted, 7);
        notifyInfoLockStatusMap = new HashMap<ClientNotifyInformation.LockStatus, Integer>();
        notifyInfoLockStatusMap.put(ClientNotifyInformation.LockStatus.inapplicable, 0);
        notifyInfoLockStatusMap.put(ClientNotifyInformation.LockStatus.unknown, 1);
        notifyInfoLockStatusMap.put(ClientNotifyInformation.LockStatus.unchanged, 2);
        notifyInfoLockStatusMap.put(ClientNotifyInformation.LockStatus.locked, 3);
        notifyInfoLockStatusMap.put(ClientNotifyInformation.LockStatus.unlocked, 4);
        notifyInfoActionMap = new HashMap<ClientNotifyInformation.Action, Integer>();
        notifyInfoActionMap.put(ClientNotifyInformation.Action.add, 0);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.copy, 1);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.delete, 2);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.restore, 3);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.revert, 4);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_revert, 5);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.resolved, 6);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.skip, 7);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_delete, 8);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_add, 9);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_update, 10);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_completed, 11);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_external, 12);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.status_completed, 13);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.status_external, 14);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.commit_modified, 15);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.commit_added, 16);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.commit_deleted, 17);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.commit_replaced, 18);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.commit_postfix_txdelta, 19);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.blame_revision, 20);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.locked, 21);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.unlocked, 22);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_lock, 23);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_unlock, 24);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.exists, 25);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.changelist_set, 26);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.changelist_clear, 27);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.changelist_moved, 39);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.merge_begin, 28);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.foreign_merge_begin, 29);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_replaced, 30);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.property_added, 31);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.property_modified, 32);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.property_deleted, 33);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.property_deleted_nonexistent, 34);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.revprop_set, 35);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.revprop_deleted, 36);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.merge_completed, 37);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.tree_conflict, 38);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_external, 40);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_started, 41);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_skip_obstruction, 42);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_skip_working_only, 43);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_skip_access_denied, 44);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_external_removed, 45);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_shadowed_add, 46);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_shadowed_update, 47);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_shadowed_delete, 48);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.merge_record_info, 49);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.upgraded_path, 50);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.merge_record_info_begin, 51);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.merge_elide_info, 52);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.patch, 53);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.patch_applied_hunk, 54);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.patch_rejected_hunk, 55);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.patch_hunk_already_applied, 56);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.commit_copied, 57);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.commit_copied_replaced, 58);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.url_redirect, 59);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.path_nonexistent, 60);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.exclude, 61);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_conflict, 62);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_missing, 63);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_out_of_date, 64);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_no_parent, 65);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_locked, 66);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_forbidden_by_server, 67);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.skip_conflicted, 68);
    }

    public static PatchCallback convert(final ISVNPatchCallback callback) {
        if (callback == null) {
            return null;
        }
        return new PatchCallback(){

            public boolean singlePatch(String pathFromPatchfile, String patchPath, String rejectPath) {
                return callback.singlePatch(pathFromPatchfile, patchPath, rejectPath);
            }
        };
    }

    public static ProplistCallback convert(final ISVNPropertyCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ProplistCallback(){

            public void singlePath(String path, Map<String, byte[]> properties) {
                SVNProperty[] data = new SVNProperty[properties.size()];
                int i = 0;
                for (Map.Entry<String, byte[]> entry : properties.entrySet()) {
                    data[i] = new SVNProperty(entry.getKey(), entry.getValue());
                    ++i;
                }
                callback.next(path, data);
            }
        };
    }

    public static Map<String, String> convertRevPropsToSVN(Map revProps) {
        if (revProps == null) {
            return null;
        }
        HashMap<String, String> retVal = new HashMap<String, String>();
        for (Map.Entry entry : revProps.entrySet()) {
            if (entry.getKey().equals("svn:date")) {
                Date date = (Date)entry.getValue();
                retVal.put("svn:date", date == null ? null : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z").format(date));
                continue;
            }
            retVal.put((String)entry.getKey(), (String)entry.getValue());
        }
        return retVal;
    }

    public static Map convertRevPropsFromSVN(Map<String, byte[]> revProps, DateFormat formatter, Calendar tDate) {
        if (revProps == null) {
            return null;
        }
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        for (Map.Entry<String, byte[]> entry : revProps.entrySet()) {
            if (entry.getKey().equals("svn:date")) {
                String dateStr = new String(entry.getValue());
                if (dateStr.length() != 27 || dateStr.charAt(26) != 'Z') continue;
                try {
                    formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z");
                    tDate = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                    tDate.setTime(formatter.parse(String.valueOf(dateStr.substring(0, 23)) + " UTC"));
                    retVal.put("svn:date", tDate.getTime());
                }
                catch (ParseException parseException) {
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            String str = null;
            try {
                str = new String(entry.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                str = new String(entry.getValue());
            }
            retVal.put(entry.getKey(), str);
        }
        return retVal;
    }

    public static LogMessageCallback convert(final ISVNLogEntryCallback callback) {
        if (callback == null) {
            return null;
        }
        return new LogMessageCallback(){
            private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z");
            private Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

            public void singleMessage(Set<ChangePath> changedPaths, long revision, Map<String, byte[]> revprops, boolean hasChildren) {
                SVNLogEntry entry = this.convert(changedPaths == null ? null : changedPaths.toArray(new ChangePath[changedPaths.size()]), revision, revprops, hasChildren);
                callback.next(entry);
            }

            private SVNLogEntry convert(ChangePath[] changedPaths, long revision, Map<String, byte[]> revProps, boolean hasChildren) {
                if (revProps == null) {
                    return new SVNLogEntry(revision, 0L, null, null, ConversionUtility.convert(changedPaths), hasChildren);
                }
                Map tRevProps = ConversionUtility.convertRevPropsFromSVN(revProps, this.formatter, this.date);
                Date date = tRevProps == null ? null : (Date)tRevProps.get("svn:date");
                return new SVNLogEntry(revision, date == null ? 0L : date.getTime(), tRevProps == null ? null : (String)tRevProps.get("svn:author"), tRevProps == null ? null : (String)tRevProps.get("svn:log"), ConversionUtility.convert(changedPaths), hasChildren);
            }
        };
    }

    public static CopySource[] convert(SVNEntryRevisionReference[] info) {
        if (info == null) {
            return null;
        }
        CopySource[] retVal = new CopySource[info.length];
        int i = 0;
        while (i < info.length) {
            retVal[i] = ConversionUtility.convert(info[i]);
            ++i;
        }
        return retVal;
    }

    public static CopySource convert(SVNEntryRevisionReference info) {
        return info == null ? null : new CopySource(info.path, ConversionUtility.convert(info.revision), ConversionUtility.convert(info.pegRevision));
    }

    public static InfoCallback convert(final ISVNEntryInfoCallback callback) {
        if (callback == null) {
            return null;
        }
        return new InfoCallback(){

            public void singleInfo(Info info) {
                callback.next(ConversionUtility.convert(info));
            }
        };
    }

    public static StatusCallback convert(final ISVNEntryStatusCallback cb) {
        if (cb == null) {
            return null;
        }
        return new StatusCallback(){

            public void doStatus(String path, Status st) {
                cb.next(ConversionUtility.convert(st));
            }
        };
    }

    public static ConflictResolverCallback convert(final ISVNConflictResolutionCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ConflictResolverCallback(){

            public ConflictResult resolve(ConflictDescriptor descrip) throws SubversionException {
                try {
                    return ConversionUtility.convert(callback.resolve(ConversionUtility.convert(descrip)));
                }
                catch (SVNConnectorException ex) {
                    throw ClientException.fromException((Throwable)ex);
                }
            }
        };
    }

    public static SVNConflictDescriptor[] convert(Set<ConflictDescriptor> descr) {
        SVNConflictDescriptor[] retVal = null;
        if (descr != null) {
            retVal = new SVNConflictDescriptor[descr.size()];
            int i = 0;
            for (ConflictDescriptor svnConflictDescriptor : descr) {
                retVal[i++] = ConversionUtility.convert(svnConflictDescriptor);
            }
        }
        return retVal;
    }

    public static SVNConflictDescriptor convert(ConflictDescriptor descr) {
        if (descr == null) {
            return null;
        }
        ConflictDescriptor.Kind tKind = descr.getKind();
        int kind = 0;
        if (tKind == ConflictDescriptor.Kind.property) {
            kind = 1;
        } else if (tKind == ConflictDescriptor.Kind.tree) {
            kind = 2;
        }
        ConflictDescriptor.Action tAction = descr.getAction();
        int action = 1;
        if (tAction == ConflictDescriptor.Action.edit) {
            action = 0;
        } else if (tAction == ConflictDescriptor.Action.delete) {
            action = 2;
        }
        Integer reason = conflictReasonMap.get(descr.getReason());
        ConflictDescriptor.Operation tOperation = descr.getOperation();
        int operation = 0;
        if (tOperation == ConflictDescriptor.Operation.merge) {
            operation = 3;
        } else if (tOperation == ConflictDescriptor.Operation.switched) {
            operation = 2;
        } else if (tOperation == ConflictDescriptor.Operation.update) {
            operation = 1;
        }
        return descr == null ? null : new SVNConflictDescriptor(descr.getPath(), kind, ConversionUtility.convert(descr.getNodeKind()), descr.getPropertyName(), descr.isBinary(), descr.getMIMEType(), action, reason == null ? 0 : reason, operation, descr.getBasePath(), descr.getTheirPath(), descr.getMyPath(), descr.getMergedPath(), ConversionUtility.convert(descr.getSrcLeftVersion()), ConversionUtility.convert(descr.getSrcRightVersion()));
    }

    public static SVNConflictVersion convert(ConflictVersion conflictVersion) {
        return conflictVersion == null ? null : new SVNConflictVersion(conflictVersion.getReposURL(), conflictVersion.getPegRevision(), conflictVersion.getPathInRepos(), ConversionUtility.convert(conflictVersion.getNodeKind()));
    }

    public static ConflictResult convert(SVNConflictResolution result) {
        return result == null ? null : new ConflictResult(ConversionUtility.convertConflictChoice(result.choice), result.mergedPath);
    }

    public static SVNMergeInfo convert(Mergeinfo info) {
        String[] paths;
        if (info == null) {
            return null;
        }
        SVNMergeInfo retVal = new SVNMergeInfo();
        String[] stringArray = paths = info.getPaths() == null ? null : info.getPaths().toArray(new String[info.getPaths().size()]);
        if (paths != null) {
            int i = 0;
            while (i < paths.length) {
                retVal.addRevisions(paths[i], ConversionUtility.convert(info.getRevisionRange(paths[i]).toArray(new RevisionRange[0])));
                ++i;
            }
        }
        return retVal;
    }

    public static RevisionRange[] convert(SVNRevisionRange[] ranges) {
        if (ranges == null) {
            return null;
        }
        RevisionRange[] retVal = new RevisionRange[ranges.length];
        int i = 0;
        while (i < ranges.length) {
            retVal[i] = ConversionUtility.convert(ranges[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNRevisionRange[] convert(RevisionRange[] ranges) {
        if (ranges == null) {
            return null;
        }
        SVNRevisionRange[] retVal = new SVNRevisionRange[ranges.length];
        int i = 0;
        while (i < ranges.length) {
            retVal[i] = ConversionUtility.convert(ranges[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNRevisionRange convert(RevisionRange range) {
        return range == null ? null : new SVNRevisionRange(ConversionUtility.convert(range.getFromRevision()), ConversionUtility.convert(range.getToRevision()));
    }

    public static RevisionRange convert(SVNRevisionRange range) {
        return range == null ? null : new RevisionRange(ConversionUtility.convert(range.from), ConversionUtility.convert(range.to));
    }

    public static SVNEntryInfo[] convert(Info[] infos) {
        if (infos == null) {
            return null;
        }
        SVNEntryInfo[] retVal = new SVNEntryInfo[infos.length];
        int i = 0;
        while (i < infos.length) {
            retVal[i] = ConversionUtility.convert(infos[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNChecksum convert(Checksum checksum) {
        return checksum == null ? null : new SVNChecksum(checksum.getKind() == Checksum.Kind.MD5 ? 0 : 1, checksum.getDigest());
    }

    public static SVNEntryInfo convert(Info info) {
        if (info == null) {
            return null;
        }
        Info.ScheduleKind tScheduleKind = info.getSchedule();
        int scheduleKind = 0;
        if (tScheduleKind == Info.ScheduleKind.add) {
            scheduleKind = 1;
        } else if (tScheduleKind == Info.ScheduleKind.delete) {
            scheduleKind = 2;
        } else if (tScheduleKind == Info.ScheduleKind.replace) {
            scheduleKind = 3;
        }
        long changeTime = info.getTextTime() == null ? 0L : info.getTextTime().getTime();
        return new SVNEntryInfo(info.getPath(), info.getWcroot(), info.getUrl(), info.getRev(), ConversionUtility.convert(info.getKind()), info.getReposRootUrl(), info.getReposUUID(), info.getLastChangedRev(), info.getLastChangedDate() == null ? 0L : info.getLastChangedDate().getTime(), info.getLastChangedAuthor(), ConversionUtility.convert(info.getLock()), info.isHasWcInfo(), scheduleKind, info.getCopyFromUrl(), info.getCopyFromRev(), changeTime, changeTime, ConversionUtility.convert(info.getChecksum()), info.getChangelistName(), info.getWorkingSize(), info.getReposSize(), ConversionUtility.convertDepth(info.getDepth()), ConversionUtility.convert(info.getConflicts()));
    }

    public static SVNLogPath[] convert(ChangePath[] paths) {
        if (paths == null) {
            return null;
        }
        SVNLogPath[] retVal = new SVNLogPath[paths.length];
        int i = 0;
        while (i < paths.length) {
            retVal[i] = ConversionUtility.convert(paths[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNLogPath convert(ChangePath path) {
        if (path == null) {
            return null;
        }
        ChangePath.Action tAction = path.getAction();
        char action = 'A';
        if (tAction == ChangePath.Action.delete) {
            action = 'D';
        } else if (tAction == ChangePath.Action.modify) {
            action = 'M';
        } else if (tAction == ChangePath.Action.replace) {
            action = 'R';
        }
        return new SVNLogPath(path.getPath(), action, path.getCopySrcPath(), path.getCopySrcRevision());
    }

    public static SVNProperty[] convertRevProps(Map<String, byte[]> data) {
        if (data == null) {
            return null;
        }
        SVNProperty[] retVal = new SVNProperty[data.size()];
        int i = 0;
        for (Map.Entry<String, byte[]> entry : data.entrySet()) {
            retVal[i] = new SVNProperty(entry.getKey(), entry.getValue());
            ++i;
        }
        return retVal;
    }

    public static SVNChangeStatus[] convert(Status[] st) {
        if (st == null) {
            return null;
        }
        SVNChangeStatus[] retVal = new SVNChangeStatus[st.length];
        int i = 0;
        while (i < st.length) {
            retVal[i] = ConversionUtility.convert(st[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNChangeStatus convert(Status st) {
        if (st == null) {
            return null;
        }
        Integer textStatus = syncStatusMap.get(st.getTextStatus());
        Integer propStatus = syncStatusMap.get(st.getPropStatus());
        Integer repoTextStatus = syncStatusMap.get(st.getRepositoryTextStatus());
        Integer repoPropStatus = syncStatusMap.get(st.getRepositoryPropStatus());
        return new SVNChangeStatus(st.getPath(), st.getUrl(), ConversionUtility.convert(st.getNodeKind()), st.getRevisionNumber(), st.getLastChangedRevisionNumber(), st.getLastChangedDate() == null ? 0L : st.getLastChangedDate().getTime(), st.getLastCommitAuthor(), textStatus == null ? 0 : textStatus, propStatus == null ? 0 : propStatus, repoTextStatus == null ? 0 : repoTextStatus, repoPropStatus == null ? 0 : repoPropStatus, st.isLocked(), st.isCopied(), st.isSwitched(), ConversionUtility.convert(st.getLocalLock()), ConversionUtility.convert(st.getReposLock()), st.getReposLastCmtRevisionNumber(), st.getReposLastCmtDate() == null ? 0L : st.getReposLastCmtDate().getTime(), ConversionUtility.convert(st.getReposKind()), st.getReposLastCmtAuthor(), st.isFileExternal(), st.isConflicted(), null, st.getChangelist());
    }

    public static int convert(NodeKind kind) {
        Integer retVal = nodeKindMap.get(kind);
        return retVal == null ? 3 : retVal;
    }

    public static int convert(ClientNotifyInformation.Action action) {
        Integer retVal = notifyInfoActionMap.get(action);
        return retVal == null ? -1 : retVal;
    }

    public static int convert(ClientNotifyInformation.Status status) {
        Integer retVal = notifyInfoStatusMap.get(status);
        return retVal == null ? 1 : retVal;
    }

    public static int convert(ClientNotifyInformation.LockStatus status) {
        Integer retVal = notifyInfoLockStatusMap.get(status);
        return retVal == null ? 1 : retVal;
    }

    public static SVNLock convert(Lock lock) {
        return lock == null ? null : new SVNLock(lock.getOwner(), lock.getPath(), lock.getToken(), lock.getComment(), lock.getCreationDate() == null ? 0L : lock.getCreationDate().getTime(), lock.getExpirationDate() == null ? 0L : lock.getExpirationDate().getTime());
    }

    public static BlameCallback convert(final ISVNAnnotationCallback cb) {
        if (cb == null) {
            return null;
        }
        return new BlameCallback(){
            private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z");
            private Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

            public void singleLine(long lineNum, long revision, Map<String, byte[]> revProps, long mergedRevision, Map<String, byte[]> mergedRevProps, String mergedPath, String line, boolean localChange) throws ClientException {
                Map tRevProps = ConversionUtility.convertRevPropsFromSVN(revProps, this.formatter, this.date);
                Map tMergedRevProps = ConversionUtility.convertRevPropsFromSVN(mergedRevProps, this.formatter, this.date);
                Date date = tRevProps == null ? null : (Date)tRevProps.get("svn:date");
                String author = tRevProps == null ? null : (String)tRevProps.get("svn:author");
                Date mergedDate = tMergedRevProps == null ? null : (Date)tMergedRevProps.get("svn:date");
                String mergedAuthor = tMergedRevProps == null ? null : (String)tMergedRevProps.get("svn:author");
                cb.annotate(line, new SVNAnnotationData(lineNum, localChange, revision, date == null ? 0L : date.getTime(), author, mergedRevision, mergedDate == null ? 0L : mergedDate.getTime(), mergedAuthor, mergedPath));
            }
        };
    }

    public static SVNRevision convert(Revision rev) {
        if (rev != null) {
            Revision.Kind kind = rev.getKind();
            if (kind == Revision.Kind.base) {
                return SVNRevision.BASE;
            }
            if (kind == Revision.Kind.committed) {
                return SVNRevision.COMMITTED;
            }
            if (kind == Revision.Kind.head) {
                return SVNRevision.HEAD;
            }
            if (kind == Revision.Kind.previous) {
                return SVNRevision.PREVIOUS;
            }
            if (kind == Revision.Kind.working) {
                return SVNRevision.WORKING;
            }
            if (kind == Revision.Kind.unspecified) {
                return SVNRevision.START;
            }
            if (kind == Revision.Kind.number) {
                return SVNRevision.fromNumber((long)((Revision.Number)rev).getNumber());
            }
            return SVNRevision.fromDate((long)((Revision.DateSpec)rev).getDate().getTime());
        }
        return null;
    }

    public static Mergeinfo.LogKind convertLogKind(int logKind) {
        return logKind == 0 ? Mergeinfo.LogKind.eligible : Mergeinfo.LogKind.merged;
    }

    public static int convertDepth(Depth depth) {
        if (depth == Depth.exclude) {
            return -1;
        }
        if (depth == Depth.empty) {
            return 0;
        }
        if (depth == Depth.files) {
            return 1;
        }
        if (depth == Depth.immediates) {
            return 2;
        }
        if (depth == Depth.infinity) {
            return 3;
        }
        return -2;
    }

    public static Depth convertDepth(int depth) {
        switch (depth) {
            case -1: {
                return Depth.exclude;
            }
            case 0: {
                return Depth.empty;
            }
            case 1: {
                return Depth.files;
            }
            case 2: {
                return Depth.immediates;
            }
            case 3: {
                return Depth.infinity;
            }
        }
        return Depth.unknown;
    }

    public static int convertConflictChoice(ConflictResult.Choice choice) {
        if (choice == ConflictResult.Choice.chooseBase) {
            return 1;
        }
        if (choice == ConflictResult.Choice.chooseTheirsFull) {
            return 2;
        }
        if (choice == ConflictResult.Choice.chooseMineFull) {
            return 3;
        }
        if (choice == ConflictResult.Choice.chooseTheirsConflict) {
            return 4;
        }
        if (choice == ConflictResult.Choice.chooseMineConflict) {
            return 5;
        }
        if (choice == ConflictResult.Choice.chooseMerged) {
            return 6;
        }
        return 0;
    }

    public static ConflictResult.Choice convertConflictChoice(int choice) {
        switch (choice) {
            case 1: {
                return ConflictResult.Choice.chooseBase;
            }
            case 2: {
                return ConflictResult.Choice.chooseTheirsFull;
            }
            case 3: {
                return ConflictResult.Choice.chooseMineFull;
            }
            case 4: {
                return ConflictResult.Choice.chooseTheirsConflict;
            }
            case 5: {
                return ConflictResult.Choice.chooseMineConflict;
            }
            case 6: {
                return ConflictResult.Choice.chooseMerged;
            }
        }
        return ConflictResult.Choice.postpone;
    }

    public static Revision convert(SVNRevision rev) {
        if (rev != null) {
            switch (rev.getKind()) {
                case 5: {
                    return Revision.BASE;
                }
                case 3: {
                    return Revision.COMMITTED;
                }
                case 7: {
                    return Revision.HEAD;
                }
                case 4: {
                    return Revision.PREVIOUS;
                }
                case 6: {
                    return Revision.WORKING;
                }
                case 0: {
                    return Revision.START;
                }
                case 1: {
                    return Revision.getInstance((long)((SVNRevision.Number)rev).getNumber());
                }
            }
            return Revision.getInstance((Date)new Date(((SVNRevision.Date)rev).getDate()));
        }
        return null;
    }

    public static SVNNotification convert(ClientNotifyInformation info) {
        return info == null ? null : new SVNNotification(info.getPath(), ConversionUtility.convert(info.getAction()), ConversionUtility.convert(info.getKind()), info.getMimeType(), ConversionUtility.convert(info.getLock()), info.getErrMsg(), ConversionUtility.convert(info.getContentState()), ConversionUtility.convert(info.getPropState()), ConversionUtility.convert(info.getLockState()), info.getRevision());
    }

    public static ISVNNotificationCallback convert(ClientNotifyCallback notify2) {
        return notify2 == null ? null : ((Notify2Wrapper)notify2).getNotify2();
    }

    public static ClientNotifyCallback convert(ISVNNotificationCallback notify2) {
        return notify2 == null ? null : new Notify2Wrapper(notify2);
    }

    public static String convertZeroCodedLine(String source) {
        if (source != null) {
            byte[] data = new byte[source.length()];
            int i = 0;
            while (i < data.length) {
                data[i] = (byte)source.charAt(i);
                ++i;
            }
            source = new String(data);
        }
        return source;
    }

    private ConversionUtility() {
    }

    public static class Notify2Wrapper
    implements ClientNotifyCallback {
        protected ISVNNotificationCallback notify;

        public Notify2Wrapper(ISVNNotificationCallback notify) {
            this.notify = notify;
        }

        public ISVNNotificationCallback getNotify2() {
            return this.notify;
        }

        public void onNotify(ClientNotifyInformation info) {
            this.notify.notify(ConversionUtility.convert(info));
        }
    }
}

