/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class JARSigningTab {
    private static final String S_SIGN_JARS = "signJAR";
    private static final String S_KEYSTORE = "keystore";
    private static final String S_KEYPASS = "keypass";
    private static final String S_ALIAS = "alias";
    private static final String S_PASSWORD = "password";
    private Button fButton;
    private Label fKeystoreLabel;
    private Text fKeystoreText;
    private Label fKeypassLabel;
    private Text fKeypassText;
    private Label fAliasLabel;
    private Text fAliasText;
    private Label fPasswordLabel;
    private Text fPasswordText;
    private BaseExportWizardPage fPage;
    private Button fBrowseButton;

    public JARSigningTab(BaseExportWizardPage page) {
        this.fPage = page;
    }

    public Control createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(3, false));
        comp.setLayoutData((Object)new GridData(768));
        this.fButton = new Button(comp, 32);
        this.fButton.setText(PDEUIMessages.AdvancedPluginExportPage_signButton);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fButton.setLayoutData((Object)gd);
        this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JARSigningTab.this.updateGroup(JARSigningTab.this.fButton.getSelection());
                JARSigningTab.this.fPage.pageChanged();
            }
        });
        this.fKeystoreLabel = this.createLabel(comp, PDEUIMessages.AdvancedPluginExportPage_keystore);
        this.fKeystoreText = this.createText(comp, 1);
        this.fBrowseButton = new Button(comp, 8);
        this.fBrowseButton.setText(PDEUIMessages.ExportWizard_browse);
        this.fBrowseButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fBrowseButton);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(JARSigningTab.this.fPage.getShell(), 4096);
                String path = JARSigningTab.this.fKeystoreText.getText();
                if (path.trim().length() == 0) {
                    path = PDEPlugin.getWorkspace().getRoot().getLocation().toString();
                }
                dialog.setFileName(path);
                String res = dialog.open();
                if (res != null) {
                    JARSigningTab.this.fKeystoreText.setText(res);
                }
            }
        });
        this.fKeypassLabel = this.createLabel(comp, PDEUIMessages.JARSigningTab_keypass);
        this.fKeypassText = this.createText(comp, 2);
        this.fKeypassText.setEchoChar('*');
        this.fAliasLabel = this.createLabel(comp, PDEUIMessages.AdvancedPluginExportPage_alias);
        this.fAliasText = this.createText(comp, 2);
        this.fPasswordLabel = this.createLabel(comp, PDEUIMessages.AdvancedPluginExportPage_password);
        this.fPasswordText = this.createText(comp, 2);
        this.fPasswordText.setEchoChar('*');
        Dialog.applyDialogFont((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.pde.doc.user.advanced_plugin_export_page");
        return comp;
    }

    protected void initialize(IDialogSettings settings) {
        this.fKeystoreText.setText(this.getString(settings, S_KEYSTORE));
        this.fKeypassText.setText(this.getString(settings, S_KEYPASS));
        this.fAliasText.setText(this.getString(settings, S_ALIAS));
        this.fPasswordText.setText(this.getString(settings, S_PASSWORD));
        this.fButton.setSelection(settings.getBoolean(S_SIGN_JARS));
        this.updateGroup(this.fButton.getSelection());
    }

    private String getString(IDialogSettings settings, String key) {
        String value = settings.get(key);
        return value == null ? "" : value;
    }

    protected Label createLabel(Composite group, String text) {
        Label label = new Label(group, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalIndent = 15;
        label.setLayoutData((Object)gd);
        return label;
    }

    protected Text createText(Composite group, int span) {
        Text text = new Text(group, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        text.setLayoutData((Object)gd);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JARSigningTab.this.fPage.pageChanged();
            }
        });
        return text;
    }

    protected String validate() {
        String error = null;
        if (this.fButton.getSelection()) {
            if (this.fKeystoreText.getText().trim().length() == 0) {
                error = PDEUIMessages.AdvancedPluginExportPage_noKeystore;
            } else if (this.fAliasText.getText().trim().length() == 0) {
                error = PDEUIMessages.AdvancedPluginExportPage_noAlias;
            } else if (this.fPasswordText.getText().trim().length() == 0) {
                error = PDEUIMessages.AdvancedPluginExportPage_noPassword;
            }
        }
        return error;
    }

    private void updateGroup(boolean enabled) {
        this.fKeystoreLabel.setEnabled(enabled);
        this.fKeystoreText.setEnabled(enabled);
        this.fBrowseButton.setEnabled(enabled);
        this.fAliasLabel.setEnabled(enabled);
        this.fAliasText.setEnabled(enabled);
        this.fPasswordLabel.setEnabled(enabled);
        this.fPasswordText.setEnabled(enabled);
        this.fKeypassLabel.setEnabled(enabled);
        this.fKeypassText.setEnabled(enabled);
    }

    protected void saveSettings(IDialogSettings settings) {
        settings.put(S_SIGN_JARS, this.fButton.getSelection());
        settings.put(S_KEYSTORE, this.fKeystoreText.getText().trim());
        settings.put(S_ALIAS, this.fAliasText.getText().trim());
        settings.put(S_PASSWORD, this.fPasswordText.getText().trim());
        settings.put(S_KEYPASS, this.fKeypassText.getText().trim());
    }

    protected String[] getSigningInfo() {
        if (this.fButton.getSelection()) {
            return new String[]{this.fAliasText.getText().trim(), this.fKeystoreText.getText().trim(), this.fPasswordText.getText().trim(), this.fKeypassText.getText().trim()};
        }
        return null;
    }
}

