/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.ecore;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.internal.ecore.DynamicEPackageService;

public class DynamicPackageRegistryReader
extends RegistryReader {
    public static final String DYNAMIC_PACKAGE_PPID = "dynamic_package";
    static final String TAG_RESOURCE = "resource";
    static final String ATT_URI = "uri";
    static final String ATT_LOCATION = "location";

    public DynamicPackageRegistryReader() {
        super(Platform.getExtensionRegistry(), DslCommonPlugin.getDefault().getBundle().getSymbolicName(), DYNAMIC_PACKAGE_PPID);
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_RESOURCE)) {
            String packageURI = element.getAttribute(ATT_URI);
            if (packageURI == null) {
                this.logMissingAttribute(element, ATT_URI);
            } else if (element.getAttribute(ATT_LOCATION) == null) {
                this.logMissingAttribute(element, ATT_LOCATION);
            } else {
                if (add) {
                    Object previous = EPackage.Registry.INSTANCE.put((Object)packageURI, (Object)new DynamicEPackageService.EPackageDescriptor.Dynamic(element, ATT_LOCATION));
                    if (previous instanceof PluginClassDescriptor) {
                        PluginClassDescriptor descriptor = (PluginClassDescriptor)previous;
                        EcorePlugin.INSTANCE.log((Object)("Both '" + descriptor.element.getContributor().getName() + "' and '" + element.getContributor().getName() + "' register a package for '" + packageURI + "'"));
                    }
                    return true;
                }
                EPackage.Registry.INSTANCE.remove((Object)packageURI);
                return true;
            }
        }
        return false;
    }

    public static class PluginClassDescriptor {
        protected IConfigurationElement element;
        protected String attributeName;

        public PluginClassDescriptor(IConfigurationElement element, String attributeName) {
            this.element = element;
            this.attributeName = attributeName;
        }

        public Object createInstance() {
            try {
                return this.element.createExecutableExtension(this.attributeName);
            }
            catch (CoreException e) {
                throw new WrappedException((Exception)((Object)e));
            }
        }
    }
}

