/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.migration;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.obeonetwork.dsl.uml2.migration.Activator;
import org.obeonetwork.dsl.uml2.migration.UmlProjectMigrationOperation;

public class MigrateUMLProject
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ArrayList projectsToMigrate = Lists.newArrayList();
        if (selection instanceof StructuredSelection) {
            Object[] objectArray = ((StructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof IProject) {
                    projectsToMigrate.add((IProject)obj);
                }
                ++n2;
            }
        }
        for (IProject project : projectsToMigrate) {
            UmlProjectMigrationOperation migrate = new UmlProjectMigrationOperation(project);
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, false, (IRunnableWithProgress)migrate);
            }
            catch (InvocationTargetException e) {
                Activator.getDefault().logError(e);
            }
            catch (InterruptedException e) {
                Activator.getDefault().logError(e);
            }
        }
        return null;
    }
}

