/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.migration;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.obeonetwork.dsl.uml2.design.api.utils.UmlViewpoints;
import org.obeonetwork.dsl.uml2.migration.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UmlProjectMigrationOperation
extends WorkspaceModifyOperation {
    private IProject project;
    private IWorkbenchPage page;
    private IWorkbenchWindow window;

    public UmlProjectMigrationOperation(IProject project) {
        this.project = project;
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.page = this.window.getActivePage();
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Migrate the project : ", 100);
            monitor.subTask("Convert to modeling project...");
            Option<ModelingProject> modelingProject = this.convertToModelingProject(monitor);
            monitor.worked(25);
            monitor.subTask("Close all opened editors...");
            this.closeOpenedEditors();
            monitor.worked(25);
            if (modelingProject.some()) {
                monitor.subTask("Activate UML viewpoints...");
                Session session = ((ModelingProject)modelingProject.get()).getSession();
                UmlViewpoints.enable((Session)session);
                monitor.worked(25);
            }
            monitor.subTask("Close the project...");
            this.project.close(monitor);
            monitor.subTask("Re-open the project...");
            this.project.open(monitor);
            monitor.worked(25);
        }
        finally {
            monitor.done();
        }
    }

    private Option<ModelingProject> convertToModelingProject(IProgressMonitor monitor) {
        try {
            ModelingProjectManager.INSTANCE.convertToModelingProject(this.project, monitor);
            Option optionalModelingProject = ModelingProject.asModelingProject((IProject)this.project);
            if (optionalModelingProject.some()) {
                return optionalModelingProject;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e);
        }
        return Options.newNone();
    }

    private void closeOpenedEditors() {
        this.page.closeAllEditors(false);
    }
}

