/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter.ui;

import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.AttributeDefinitionDate;
import org.eclipse.rmf.reqif10.AttributeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.AttributeDefinitionInteger;
import org.eclipse.rmf.reqif10.AttributeDefinitionReal;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.search.filter.AbstractTextFilter;
import org.eclipse.rmf.reqif10.search.filter.BoolFilter;
import org.eclipse.rmf.reqif10.search.filter.DateFilter;
import org.eclipse.rmf.reqif10.search.filter.EnumFilter;
import org.eclipse.rmf.reqif10.search.filter.IFilter;
import org.eclipse.rmf.reqif10.search.filter.NumberFilter;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterControlBoolean;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterControlDate;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterControlEnum;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterControlNumber;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterControlString;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterPanel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class FilterControl
extends Composite {
    protected IFilter templateFilter;
    protected Object attribute;
    private Combo operatorControl;

    public FilterControl(FilterPanel parent, AttributeDefinition attribute) {
        super((Composite)parent, 0x800000);
        this.attribute = attribute;
        this.init();
    }

    public FilterControl(FilterPanel parent, DateFilter.InternalAttribute attribute) {
        super((Composite)parent, 0x800000);
        this.attribute = attribute;
        this.init();
    }

    public FilterControl(FilterPanel parent, AbstractTextFilter.InternalAttribute attribute) {
        super((Composite)parent, 0x800000);
        this.attribute = attribute;
        this.init();
    }

    public FilterControl(FilterPanel parent, IFilter template) {
        super((Composite)parent, 0x800000);
        this.templateFilter = template;
        this.attribute = template.getAttribute();
        this.init();
    }

    protected final IFilter.Operator getOperator() {
        return this.getOperators().get(this.operatorControl.getSelectionIndex());
    }

    protected abstract List<IFilter.Operator> getOperators();

    protected abstract void updateValueControls(boolean var1);

    public abstract IFilter getFilter();

    private void init() {
        if (this.attribute == null) {
            throw new NullPointerException();
        }
        this.setLayout((Layout)new GridLayout(3, false));
        this.createOperators();
        this.updateValueControls(this.templateFilter != null);
    }

    private void createOperators() {
        this.operatorControl = new Combo((Composite)this, 2060);
        GridData layoutData = new GridData(16384, 0x1000000, false, false);
        this.operatorControl.setLayoutData((Object)layoutData);
        for (IFilter.Operator operator : this.getOperators()) {
            this.operatorControl.add(operator.toLocaleString());
        }
        this.operatorControl.select(0);
        if (this.templateFilter != null) {
            this.operatorControl.select(this.getOperators().indexOf(this.templateFilter.getOperator()));
        }
        this.operatorControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterControl.this.updateValueControls(false);
                FilterControl.this.layout(true);
            }
        });
    }

    public static FilterControl createFilterControl(FilterPanel parent, IFilter filter) {
        if (filter instanceof AbstractTextFilter) {
            return new FilterControlString(parent, (AbstractTextFilter)filter);
        }
        if (filter instanceof DateFilter) {
            return new FilterControlDate(parent, (DateFilter)filter);
        }
        if (filter instanceof NumberFilter) {
            return new FilterControlNumber(parent, (NumberFilter)filter);
        }
        if (filter instanceof BoolFilter) {
            return new FilterControlBoolean(parent, (BoolFilter)filter);
        }
        if (filter instanceof EnumFilter) {
            return new FilterControlEnum(parent, (EnumFilter)filter);
        }
        throw new IllegalArgumentException("Don't know how to create: " + filter);
    }

    public static FilterControl createFilterControl(FilterPanel parent, AbstractTextFilter.InternalAttribute internalTextAttribute) {
        return new FilterControlString(parent, internalTextAttribute);
    }

    public static FilterControl createFilterControl(FilterPanel parent, DateFilter.InternalAttribute internalDateAttribute) {
        return new FilterControlDate(parent, internalDateAttribute);
    }

    public static FilterControl createFilterControl(FilterPanel parent, AttributeDefinition attribute) {
        if (attribute instanceof AttributeDefinitionString || attribute instanceof AttributeDefinitionXHTML) {
            return new FilterControlString(parent, attribute);
        }
        if (attribute instanceof AttributeDefinitionInteger || attribute instanceof AttributeDefinitionReal) {
            return new FilterControlNumber(parent, attribute);
        }
        if (attribute instanceof AttributeDefinitionDate) {
            return new FilterControlDate(parent, (AttributeDefinitionDate)attribute);
        }
        if (attribute instanceof AttributeDefinitionBoolean) {
            return new FilterControlBoolean(parent, (AttributeDefinitionBoolean)attribute);
        }
        if (attribute instanceof AttributeDefinitionEnumeration) {
            return new FilterControlEnum(parent, (AttributeDefinitionEnumeration)attribute);
        }
        throw new IllegalArgumentException("Don't know how to create (yet): " + attribute);
    }

    public static String getString(String key) {
        return ResourceBundle.getBundle("plugin").getString(key);
    }
}

