/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdi.internal.ArrayReferenceImpl;
import org.eclipse.jdi.internal.JDIMessages;
import org.eclipse.jdi.internal.MirrorImpl;
import org.eclipse.jdi.internal.ObjectReferenceImpl;
import org.eclipse.jdi.internal.ReferenceTypeImpl;
import org.eclipse.jdi.internal.TypeImpl;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.jdwp.JdwpArrayID;
import org.eclipse.jdi.internal.jdwp.JdwpObjectID;
import org.eclipse.jdi.internal.jdwp.JdwpReplyPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayTypeImpl
extends ReferenceTypeImpl
implements ArrayType {
    public static final byte typeTag = 3;
    private Type fComponentType;
    private String fComponentTypeName;

    public ArrayTypeImpl(VirtualMachineImpl vmImpl, JdwpArrayID arrayID) {
        super("ArrayType", vmImpl, arrayID);
    }

    public ArrayTypeImpl(VirtualMachineImpl vmImpl, JdwpArrayID arrayID, String signature, String genericSignature) {
        super("ArrayType", vmImpl, arrayID, signature, genericSignature);
    }

    @Override
    public byte typeTag() {
        return 3;
    }

    @Override
    public Value createNullValue() {
        return new ArrayReferenceImpl(this.virtualMachineImpl(), new JdwpObjectID(this.virtualMachineImpl()));
    }

    @Override
    public String componentSignature() {
        return this.signature().substring(1);
    }

    @Override
    public Type componentType() throws ClassNotLoadedException {
        if (this.fComponentType == null) {
            this.fComponentType = TypeImpl.create(this.virtualMachineImpl(), this.componentSignature(), this.classLoader());
        }
        return this.fComponentType;
    }

    @Override
    public String componentTypeName() {
        if (this.fComponentTypeName == null) {
            this.fComponentTypeName = ArrayTypeImpl.signatureToName(this.componentSignature());
        }
        return this.fComponentTypeName;
    }

    @Override
    public ArrayReference newInstance(int length) {
        this.initJdwpRequest();
        try {
            ArrayReferenceImpl arrayRef;
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            DataOutputStream outData = new DataOutputStream(outBytes);
            this.write(this, outData);
            this.writeInt(length, "length", outData);
            JdwpReplyPacket replyPacket = this.requestVM(1025, outBytes);
            this.defaultReplyErrorHandler(replyPacket.errorCode());
            DataInputStream replyData = replyPacket.dataInStream();
            ArrayReferenceImpl arrayReferenceImpl = arrayRef = (ArrayReferenceImpl)ObjectReferenceImpl.readObjectRefWithTag(this, replyData);
            return arrayReferenceImpl;
        }
        catch (IOException e) {
            this.defaultIOExceptionHandler(e);
            return null;
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    @Override
    public List<Location> locationsOfLine(int line) {
        return Collections.EMPTY_LIST;
    }

    public static ArrayTypeImpl read(MirrorImpl target, DataInputStream in) throws IOException {
        VirtualMachineImpl vmImpl = target.virtualMachineImpl();
        JdwpArrayID ID = new JdwpArrayID(vmImpl);
        ID.read(in);
        if (target.fVerboseWriter != null) {
            target.fVerboseWriter.println("arrayType", ID.value());
        }
        if (ID.isNull()) {
            return null;
        }
        ArrayTypeImpl mirror = (ArrayTypeImpl)vmImpl.getCachedMirror(ID);
        if (mirror == null) {
            mirror = new ArrayTypeImpl(vmImpl, ID);
            vmImpl.addCachedMirror(mirror);
        }
        return mirror;
    }

    @Override
    public int modifiers() {
        return 17;
    }

    @Override
    public List<Field> fields() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Method> methods() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<Field, Value> getValues(List<? extends Field> fields) {
        if (fields.isEmpty()) {
            return new HashMap<Field, Value>();
        }
        throw new IllegalArgumentException(JDIMessages.ArrayTypeImpl_getValues_not_allowed_on_array_1);
    }

    @Override
    public List<ReferenceType> nestedTypes() {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected int status() {
        return 7;
    }

    public static ArrayTypeImpl readWithSignature(MirrorImpl target, boolean withGenericSignature, DataInputStream in) throws IOException {
        VirtualMachineImpl vmImpl = target.virtualMachineImpl();
        JdwpArrayID ID = new JdwpArrayID(vmImpl);
        ID.read(in);
        if (target.fVerboseWriter != null) {
            target.fVerboseWriter.println("arrayType", ID.value());
        }
        String signature = target.readString("signature", in);
        String genericSignature = null;
        if (withGenericSignature) {
            genericSignature = target.readString("generic signature", in);
        }
        if (ID.isNull()) {
            return null;
        }
        ArrayTypeImpl mirror = (ArrayTypeImpl)vmImpl.getCachedMirror(ID);
        if (mirror == null) {
            mirror = new ArrayTypeImpl(vmImpl, ID);
            vmImpl.addCachedMirror(mirror);
        }
        mirror.setSignature(signature);
        mirror.setGenericSignature(genericSignature);
        return mirror;
    }

    @Override
    public List<Location> allLineLocations() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Method> allMethods() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Field> allFields() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String sourceName() throws AbsentInformationException {
        throw new AbsentInformationException(JDIMessages.ArrayTypeImpl_No_source_name_for_Arrays_1);
    }

    @Override
    public List<Field> visibleFields() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Method> visibleMethods() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Field fieldByName(String arg1) {
        return null;
    }

    @Override
    public List<Method> methodsByName(String arg1) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Method> methodsByName(String arg1, String arg2) {
        return Collections.EMPTY_LIST;
    }
}

