/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.traceabilitymodel.presentation.ext;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class EMFEditorLabelProvider
implements ILabelProvider,
ITableLabelProvider,
INotifyChangedListener,
IColorProvider,
ITableColorProvider,
IFontProvider,
ITableFontProvider {
    public static final Color RED = new Color((Device)Display.getDefault(), 240, 70, 0);
    public static final Color ORANGE = new Color((Device)Display.getDefault(), 240, 170, 0);
    public static final Color BLUE = new Color((Device)Display.getDefault(), 50, 80, 250);
    public static final Color LBLUE = new Color((Device)Display.getDefault(), 115, 150, 250);
    public static final Color GREEN = new Color((Device)Display.getDefault(), 80, 210, 70);
    protected AdapterFactoryLabelProvider adapterFactoryLabelProvider = null;
    FontRegistry registry = new FontRegistry();
    protected Hashtable<Object, Integer> highlight = new Hashtable();

    public EMFEditorLabelProvider(AdapterFactoryLabelProvider adapterFactoryLabelProvider) {
        this.adapterFactoryLabelProvider = adapterFactoryLabelProvider;
    }

    public Font getFont(Object element) {
        return this.getFont(element, 0);
    }

    public Color getBackground(Object element) {
        return this.getBackground(element, 0);
    }

    public Color getForeground(Object element) {
        return this.getForeground(element, 0);
    }

    public Font getFont(Object element, int columnIndex) {
        if (this.highlight.containsKey(element)) {
            return this.registry.getBold(Display.getCurrent().getSystemFont().getFontData()[0].getName());
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (!this.highlight.containsKey(element)) {
            return null;
        }
        switch (this.highlight.get(element)) {
            case 1: {
                return RED;
            }
            case 2: {
                return ORANGE;
            }
            case 3: {
                return BLUE;
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        return this.adapterFactoryLabelProvider.getImage(element);
    }

    public String getText(Object element) {
        return this.adapterFactoryLabelProvider.getText(element);
    }

    public void notifyChanged(Notification notification) {
        this.adapterFactoryLabelProvider.notifyChanged(notification);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return this.adapterFactoryLabelProvider.getColumnImage(element, columnIndex);
    }

    public String getColumnText(Object element, int columnIndex) {
        return this.adapterFactoryLabelProvider.getColumnText(element, columnIndex);
    }

    public void addListener(ILabelProviderListener listener) {
        this.adapterFactoryLabelProvider.addListener(listener);
    }

    public void dispose() {
        this.adapterFactoryLabelProvider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.adapterFactoryLabelProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.adapterFactoryLabelProvider.removeListener(listener);
    }

    public void clearHighlighting() {
        this.highlight.clear();
    }

    public void highlightObjects(ArrayList<Object> objects, int type) {
        if (type == 0) {
            for (Object o : objects) {
                this.highlight.remove(o);
            }
        } else {
            for (Object o : objects) {
                this.highlight.put(o, type);
            }
        }
    }

    public void highlightObject(Object o, int type) {
        if (type == 0) {
            this.highlight.remove(o);
        } else {
            this.highlight.put(o, type);
        }
    }
}

