/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.traceabilitymodel.presentation.ext;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mofscript.traceabilitymodel.Block;
import org.eclipse.mofscript.traceabilitymodel.File;
import org.eclipse.mofscript.traceabilitymodel.ModelElementRef;
import org.eclipse.mofscript.traceabilitymodel.Trace;
import org.eclipse.mofscript.traceabilitymodel.TraceableSegment;
import org.eclipse.mofscript.traceabilitymodel.presentation.ext.ITraceabilityEnabledEditor;

public class SourceModelHighlightingProvider {
    public void highlightForObject(EObject o, ITraceabilityEnabledEditor editor) {
        try {
            editor.clearHighlighting();
            if (o instanceof Trace) {
                this.highlightForTrace((Trace)o, editor);
            } else if (o instanceof File) {
                this.highlightForFile((File)o, editor);
            } else if (o instanceof TraceableSegment) {
                this.highlightForTraceableSegment((TraceableSegment)o, editor);
            } else if (o instanceof ModelElementRef) {
                this.highlightForModelElementRef((ModelElementRef)o, editor);
            } else if (o instanceof Block) {
                this.highlightForBlock((Block)o, editor);
            }
        }
        catch (Exception exception) {}
    }

    protected void highlightForTrace(Trace o, ITraceabilityEnabledEditor editor) {
        editor.highlightObject(o.getSegment(), 2);
        editor.highlightObject(o.getOriginatinElement(), 3);
    }

    protected void highlightForFile(File o, ITraceabilityEnabledEditor editor) {
    }

    protected void highlightForTraceableSegment(TraceableSegment o, ITraceabilityEnabledEditor editor) {
    }

    protected void highlightForModelElementRef(ModelElementRef o, ITraceabilityEnabledEditor editor) {
    }

    protected void highlightForBlock(Block o, ITraceabilityEnabledEditor editor) {
    }
}

