/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.core.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenModelHelper {
    private Log log = LogFactory.getLog(this.getClass());

    static {
        EcorePackage.eINSTANCE.getEFactoryInstance();
        GenModelPackage.eINSTANCE.getEFactoryInstance();
    }

    public void registerGenModel(ResourceSet rs, URI genmodelURI) throws ConfigurationException {
        Resource res = rs.getResource(genmodelURI, true);
        if (res == null) {
            throw new ConfigurationException("Couldn't find resource under  " + genmodelURI);
        }
        for (EObject object : res.getContents()) {
            if (!(object instanceof GenModel)) continue;
            this.registerGenModel((GenModel)object);
        }
    }

    protected Collection<GenPackage> collectGenPackages(GenModel genModel) {
        ArrayList<GenPackage> pkgs = new ArrayList<GenPackage>();
        for (GenPackage pkg : genModel.getGenPackages()) {
            pkgs.add(pkg);
            pkgs.addAll(this.collectGenPackages(pkg));
        }
        pkgs.addAll((Collection<GenPackage>)genModel.getUsedGenPackages());
        return pkgs;
    }

    protected Collection<GenPackage> collectGenPackages(GenPackage genPackage) {
        ArrayList<GenPackage> pkgs = new ArrayList<GenPackage>();
        for (GenPackage pkg : genPackage.getNestedGenPackages()) {
            pkgs.add(pkg);
            pkgs.addAll(this.collectGenPackages(pkg));
        }
        return pkgs;
    }

    public void registerGenModel(GenModel genModel) {
        Map registry = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
        for (GenPackage pkg : this.collectGenPackages(genModel)) {
            if (pkg.eIsProxy()) {
                this.log.debug((Object)("Unresolved proxy for GenPackage " + EcoreUtil.getURI((EObject)pkg)));
                continue;
            }
            String nsURI = pkg.getEcorePackage().getNsURI();
            if (nsURI == null) continue;
            URI newUri = pkg.eResource().getURI();
            if (registry.containsKey(nsURI)) {
                URI oldURI = (URI)registry.get(nsURI);
                if (oldURI.equals((Object)newUri)) continue;
                this.log.warn((Object)("There is already a GenModel registered for NamespaceURI '" + nsURI + "'. It will be overwritten from '" + oldURI + "' to '" + newUri + "'"));
            }
            registry.put(nsURI, newUri);
            if (!this.log.isInfoEnabled()) continue;
            this.log.info((Object)("Registered GenModel '" + nsURI + "' from '" + newUri + "'"));
        }
    }
}

