/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.criteria;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Operator implements Enumerator
{
    EQUALS(0, "EQUALS", "Equals"),
    NOT_EQUALS(1, "NOT_EQUALS", "Not Equals"),
    CONTAINS(2, "CONTAINS", "Contains"),
    NOT_CONTAINS(3, "NOT_CONTAINS", "Not Contains");

    public static final int EQUALS_VALUE = 0;
    public static final int NOT_EQUALS_VALUE = 1;
    public static final int CONTAINS_VALUE = 2;
    public static final int NOT_CONTAINS_VALUE = 3;
    private static final Operator[] VALUES_ARRAY;
    public static final List<Operator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Operator[]{EQUALS, NOT_EQUALS, CONTAINS, NOT_CONTAINS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Operator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Operator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Operator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Operator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Operator get(int value) {
        switch (value) {
            case 0: {
                return EQUALS;
            }
            case 1: {
                return NOT_EQUALS;
            }
            case 2: {
                return CONTAINS;
            }
            case 3: {
                return NOT_CONTAINS;
            }
        }
        return null;
    }

    private Operator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

