/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.search.filter.AbstractAttributeFilter;
import org.eclipse.rmf.reqif10.search.filter.IFilter;

public class EnumFilter
extends AbstractAttributeFilter {
    public static final ImmutableSet<IFilter.Operator> SUPPORTED_OPERATORS = Sets.immutableEnumSet((Enum)IFilter.Operator.EQUALS, (Enum[])new IFilter.Operator[]{IFilter.Operator.NOT_EQUALS, IFilter.Operator.CONTAINS_ALL, IFilter.Operator.CONTAINS_ANY, IFilter.Operator.IS_SET, IFilter.Operator.IS_NOT_SET});
    private AttributeDefinitionEnumeration attributeDefinition;
    private IFilter.Operator operator;
    private HashSet<EnumValue> filterValues;
    private HashSet<EnumValue> defaultValues;

    public EnumFilter(IFilter.Operator operator, Collection<EnumValue> value, AttributeDefinitionEnumeration attributeDefinition) {
        if (!SUPPORTED_OPERATORS.contains((Object)operator)) {
            throw new IllegalArgumentException("This filter does not support the " + operator.toString() + " operation");
        }
        if (value == null && operator != IFilter.Operator.IS_SET && operator != IFilter.Operator.IS_NOT_SET) {
            throw new IllegalArgumentException("value1 can not be null");
        }
        this.attributeDefinition = attributeDefinition;
        this.operator = operator;
        this.filterValues = value == null ? new HashSet() : new HashSet<EnumValue>(value);
        this.defaultValues = attributeDefinition.getDefaultValue() != null ? new HashSet(attributeDefinition.getDefaultValue().getValues()) : new HashSet();
    }

    @Override
    public boolean match(SpecElementWithAttributes element) {
        if (this.operator == IFilter.Operator.IS_SET || this.operator == IFilter.Operator.IS_NOT_SET) {
            return super.match(element);
        }
        AttributeValueEnumeration attributeValue = (AttributeValueEnumeration)ReqIF10Util.getAttributeValue((SpecElementWithAttributes)element, (AttributeDefinition)this.attributeDefinition);
        HashSet<Object> elementValues = null;
        elementValues = attributeValue == null || !attributeValue.isSetValues() ? (AbstractAttributeFilter.isSetAttribute(element, (AttributeDefinition)this.attributeDefinition) ? this.defaultValues : null) : new HashSet(attributeValue.getValues());
        if (elementValues == null || elementValues.size() == 0) {
            switch (this.operator) {
                case NOT_EQUALS: {
                    return !this.filterValues.isEmpty();
                }
                case EQUALS: 
                case CONTAINS_ALL: 
                case CONTAINS_ANY: {
                    return this.filterValues.isEmpty();
                }
            }
            throw new IllegalArgumentException("This filter does not support the " + (Object)((Object)this.operator) + " operation");
        }
        switch (this.operator) {
            case EQUALS: {
                return elementValues.equals(this.filterValues);
            }
            case NOT_EQUALS: {
                return !elementValues.equals(this.filterValues);
            }
            case CONTAINS_ALL: {
                return elementValues.containsAll(this.filterValues);
            }
            case CONTAINS_ANY: {
                for (EnumValue enumValue : this.filterValues) {
                    if (!elementValues.contains(enumValue)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException("This filter does not support the " + (Object)((Object)this.operator) + " operation");
    }

    public AttributeDefinitionEnumeration getAttribute() {
        return this.attributeDefinition;
    }

    @Override
    public IFilter.Operator getOperator() {
        return this.operator;
    }

    @Override
    public Collection<EnumValue> getFilterValue1() {
        return this.filterValues;
    }

    @Override
    public Object getFilterValue2() {
        return null;
    }

    @Override
    public ImmutableSet<IFilter.Operator> getSupportedOperators() {
        return SUPPORTED_OPERATORS;
    }

    @Override
    public String getFilterValue1AsString() {
        return this.enumValuesAsString((Collection<EnumValue>)this.getFilterValue1());
    }

    @Override
    public String getFilterValue2AsString() {
        return null;
    }

    private String enumValuesAsString(Collection<EnumValue> values) {
        StringBuilder sb = new StringBuilder("[");
        Iterator<EnumValue> iterator = values.iterator();
        while (iterator.hasNext()) {
            EnumValue enumValue = iterator.next();
            String label = enumValue.getLongName();
            if (label == null) {
                label = enumValue.getDesc();
            }
            if (label == null) {
                label = "ID=" + enumValue.getIdentifier();
            }
            sb.append(label);
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

