/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.interpreter;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationContext;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationResult;
import org.eclipse.acceleo.ui.interpreter.view.Variable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class SiriusEvaluationTask
implements Callable<EvaluationResult> {
    private EvaluationContext context;

    public SiriusEvaluationTask(EvaluationContext context) {
        this.context = context;
    }

    @Override
    public EvaluationResult call() throws Exception {
        Session curSession;
        EObject target;
        this.checkCancelled();
        String expression = this.context.getExpression();
        if (this.context.getTargetEObjects().isEmpty()) {
            Status errorStatus = new Status(4, "org.eclipse.sirius.common.acceleo.interpreter", "No target for evaluation of " + expression);
            return new EvaluationResult((IStatus)errorStatus);
        }
        EObject semanticTarget = target = (EObject)this.context.getTargetEObjects().get(0);
        if (target instanceof DSemanticDecorator) {
            semanticTarget = ((DSemanticDecorator)target).getTarget();
        }
        IInterpreter vpInterpreter = (curSession = SessionManager.INSTANCE.getSession(semanticTarget)) != null ? curSession.getInterpreter() : CompoundInterpreter.INSTANCE.getInterpreterForExpression(expression);
        assert (vpInterpreter != null);
        this.checkCancelled();
        for (Variable var : this.context.getVariables()) {
            vpInterpreter.setVariable(var.getName(), var.getValue());
        }
        EvaluationResult evaluationResult = null;
        try {
            Object result = vpInterpreter.evaluate(target, expression);
            IStatus status = this.createResultStatus(result);
            evaluationResult = new EvaluationResult(result, status);
        }
        catch (EvaluationException e) {
            Status status = new Status(4, "org.eclipse.sirius.common.acceleo.interpreter", e.getMessage(), (Throwable)e);
            evaluationResult = new EvaluationResult((IStatus)status);
        }
        assert (evaluationResult != null);
        return evaluationResult;
    }

    private IStatus createResultStatus(Object result) {
        if (result == null) {
            return new Status(0, "org.eclipse.sirius.common.acceleo.interpreter", "");
        }
        String type = result.getClass().getSimpleName();
        String size = null;
        if (result instanceof String) {
            size = String.valueOf(((String)result).length());
        } else if (result instanceof Collection) {
            size = String.valueOf(((Collection)result).size());
        }
        String message = "Result of type " + type;
        if (size != null) {
            message = String.valueOf(message) + " and size " + size;
        }
        return new Status(0, "org.eclipse.sirius.common.acceleo.interpreter", message);
    }

    private void checkCancelled() {
        if (Thread.currentThread().isInterrupted()) {
            throw new CancellationException();
        }
    }
}

