/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.dialog;

import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.views.navigator.ResourceComparator;

public abstract class AbstractFolderSelectionDialog
extends ElementTreeSelectionDialog
implements ISelectionChangedListener {
    private Button fNewFolderButton;
    private IContainer fSelectedContainer;

    public AbstractFolderSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setComparator((ViewerComparator)new ResourceComparator(1));
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.getTreeViewer().expandToLevel(2);
        this.fNewFolderButton = new Button(result, 8);
        this.fNewFolderButton.setText("New Folder");
        this.fNewFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractFolderSelectionDialog.this.newFolderButtonPressed();
            }
        });
        this.fNewFolderButton.setFont(parent.getFont());
        this.fNewFolderButton.setLayoutData((Object)new GridData());
        Dialog.applyDialogFont((Control)this.fNewFolderButton);
        Object gd = this.fNewFolderButton.getLayoutData();
        if (gd instanceof GridData) {
            if (this.fNewFolderButton.getFont().equals((Object)JFaceResources.getDefaultFont())) {
                this.fNewFolderButton.setFont(JFaceResources.getDialogFont());
            }
            GC gc = new GC((Drawable)this.fNewFolderButton);
            gc.setFont(this.fNewFolderButton.getFont());
            FontMetrics fFontMetrics = gc.getFontMetrics();
            gc.dispose();
            int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fFontMetrics, (int)61);
            ((GridData)gd).widthHint = Math.max(widthHint, this.fNewFolderButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        }
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private void updateNewFolderButtonState() {
        Object first;
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        this.fSelectedContainer = null;
        if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof IContainer) {
            this.fSelectedContainer = (IContainer)first;
        }
        this.fNewFolderButton.setEnabled(this.fSelectedContainer != null);
    }

    protected void newFolderButtonPressed() {
        NewFolderDialog dialog = new NewFolderDialog(this.getShell(), this.fSelectedContainer);
        if (dialog.open() == 0) {
            TreeViewer treeViewer = this.getTreeViewer();
            treeViewer.refresh((Object)this.fSelectedContainer);
            if (dialog.getResult() != null) {
                Object createdFolder = dialog.getResult()[0];
                treeViewer.reveal(createdFolder);
                treeViewer.setSelection((ISelection)new StructuredSelection(createdFolder));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateNewFolderButtonState();
    }
}

