/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.SubmoduleInitCommand;
import org.eclipse.jgit.api.SubmoduleUpdateCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.team.core.TeamException;

public class SubmoduleUpdateOperation
implements IEGitOperation {
    private final Repository repository;
    private final Collection<String> paths;

    public SubmoduleUpdateOperation(Repository repository) {
        this.repository = repository;
        this.paths = new ArrayList<String>();
    }

    public SubmoduleUpdateOperation addPath(String path) {
        this.paths.add(path);
        return this;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                pm.beginTask("", 3);
                Git git = Git.wrap((Repository)SubmoduleUpdateOperation.this.repository);
                Collection updated = null;
                try {
                    try {
                        SubmoduleInitCommand init = git.submoduleInit();
                        for (String path : SubmoduleUpdateOperation.this.paths) {
                            init.addPath(path);
                        }
                        init.call();
                        pm.worked(1);
                        SubmoduleUpdateCommand update = git.submoduleUpdate();
                        for (String path : SubmoduleUpdateOperation.this.paths) {
                            update.addPath(path);
                        }
                        update.setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)new SubProgressMonitor(pm, 2)));
                        MergeStrategy strategy = Activator.getDefault().getPreferredMergeStrategy();
                        if (strategy != null) {
                            update.setStrategy(strategy);
                        }
                        updated = update.call();
                        pm.worked(1);
                        SubProgressMonitor refreshMonitor = new SubProgressMonitor(pm, 1);
                        refreshMonitor.beginTask("", updated.size());
                        for (String path : updated) {
                            Repository subRepo = SubmoduleWalk.getSubmoduleRepository((Repository)SubmoduleUpdateOperation.this.repository, (String)path);
                            if (subRepo != null) {
                                ProjectUtil.refreshValidProjects(ProjectUtil.getValidOpenProjects(subRepo), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)refreshMonitor, 1));
                                continue;
                            }
                            refreshMonitor.worked(1);
                        }
                        refreshMonitor.done();
                    }
                    catch (GitAPIException e) {
                        throw new TeamException(e.getLocalizedMessage(), e.getCause());
                    }
                    catch (IOException e) {
                        throw new TeamException(e.getLocalizedMessage(), e.getCause());
                    }
                }
                finally {
                    if (updated != null && !updated.isEmpty()) {
                        SubmoduleUpdateOperation.this.repository.notifyIndexChanged();
                    }
                    pm.done();
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

