/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.core.collection;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.monitor.core.collection.IUsageCollector;
import org.eclipse.mylyn.internal.monitor.core.collection.InteractionEventClassifier;
import org.eclipse.mylyn.internal.monitor.core.collection.Messages;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class DataOverviewCollector
implements IUsageCollector {
    private static long FIVEMININMS = 300000L;
    private final Map<Integer, Integer> interactionHistorySizes = new HashMap<Integer, Integer>();
    private final Map<Integer, List<Date>> interactionHistoryRanges = new HashMap<Integer, List<Date>>();
    private final Map<Integer, Long> interactionHistoryActiveDuration = new HashMap<Integer, Long>();
    private int currentUser = -1;
    private InteractionEvent lastUserEvent;
    private static int startDatePosition = 0;
    private static int endDatePosition = 1;
    private String filePrefix = "";

    public DataOverviewCollector(String prefix) {
        this.filePrefix = prefix;
    }

    @Override
    public String getReportTitle() {
        return Messages.DataOverviewCollector_Data_Overview;
    }

    @Override
    public void consumeEvent(InteractionEvent event, int userId) {
        long elapsed;
        List<Object> dateRange;
        if (!this.interactionHistorySizes.containsKey(userId)) {
            this.interactionHistorySizes.put(userId, 0);
        }
        this.interactionHistorySizes.put(userId, this.interactionHistorySizes.get(userId) + 1);
        if (!this.interactionHistoryRanges.containsKey(userId)) {
            dateRange = new ArrayList(2);
            this.interactionHistoryRanges.put(userId, dateRange);
        }
        if ((dateRange = this.interactionHistoryRanges.get(userId)).size() == 0) {
            dateRange.add(event.getDate());
        } else if (dateRange.size() == 1) {
            dateRange.add(event.getDate());
        } else {
            dateRange.set(endDatePosition, event.getDate());
        }
        if (this.currentUser == -1 || this.currentUser != userId) {
            this.lastUserEvent = event;
            this.currentUser = userId;
        }
        if ((elapsed = event.getDate().getTime() - this.lastUserEvent.getDate().getTime()) < FIVEMININMS) {
            if (!this.interactionHistoryActiveDuration.containsKey(userId)) {
                this.interactionHistoryActiveDuration.put(userId, new Long(0L));
            }
            this.interactionHistoryActiveDuration.put(userId, this.interactionHistoryActiveDuration.get(userId) + elapsed);
        }
        this.lastUserEvent = event;
    }

    @Override
    public List<String> getReport() {
        ArrayList<String> report = new ArrayList<String>();
        report.add(Messages.DataOverviewCollector__h4_Data_Overview_h4_);
        report.add(String.valueOf(Messages.DataOverviewCollector_Number_of_Users_) + this.interactionHistorySizes.keySet().size() + "<br>");
        for (Map.Entry<Integer, Integer> entry : this.interactionHistorySizes.entrySet()) {
            report.add(entry.getKey() + ": " + entry.getValue() + Messages.DataOverviewCollector_events);
            report.add(String.valueOf(InteractionEventClassifier.formatDuration(this.interactionHistoryActiveDuration.get(entry.getKey()))) + Messages.DataOverviewCollector_active_use);
            List<Date> dateRange = this.interactionHistoryRanges.get(entry.getKey());
            long duration = dateRange.get(endDatePosition).getTime() - dateRange.get(startDatePosition).getTime();
            report.add(MessageFormat.format(Messages.DataOverviewCollector_TO_PERIOD_OF_HOURS, dateRange.get(startDatePosition), dateRange.get(endDatePosition), InteractionEventClassifier.formatDuration(duration)));
            report.add("<br><br>");
        }
        return report;
    }

    @Override
    public void exportAsCSVFile(String directory) {
        String filename = String.valueOf(directory) + File.separator + this.filePrefix + "baseLine.csv";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(filename)));
            writer.write(Messages.DataOverviewCollector_CSV_USER);
            writer.write(",");
            writer.write(Messages.DataOverviewCollector_CSV_EVENTS);
            writer.write(",");
            writer.write(Messages.DataOverviewCollector_CSV_START);
            writer.write(",");
            writer.write(Messages.DataOverviewCollector_CSV_END);
            writer.write(",");
            writer.write(Messages.DataOverviewCollector_CSV_ACTIVE_USE);
            writer.write(",");
            writer.write(Messages.DataOverviewCollector_CSV_ELAPSED_USE);
            writer.newLine();
            for (Map.Entry<Integer, Integer> entry : this.interactionHistorySizes.entrySet()) {
                writer.write(entry.getKey().toString());
                writer.write(",");
                writer.write(entry.getValue().toString());
                writer.write(",");
                List<Date> dateRange = this.interactionHistoryRanges.get(entry.getKey());
                writer.write(dateRange.get(startDatePosition).toString());
                writer.write(",");
                writer.write(dateRange.get(endDatePosition).toString());
                writer.write(",");
                long elapsed = this.interactionHistoryActiveDuration.get(entry.getKey());
                writer.write(InteractionEventClassifier.formatDuration(elapsed));
                writer.write(",");
                long duration = dateRange.get(endDatePosition).getTime() - dateRange.get(startDatePosition).getTime();
                writer.write(InteractionEventClassifier.formatDuration(duration));
                writer.newLine();
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.core", "Unable to write CVS file <" + filename + ">", (Throwable)e));
        }
    }

    public long getActiveUseOfUser(int userid) {
        if (this.interactionHistoryActiveDuration.containsKey(userid)) {
            return this.interactionHistoryActiveDuration.get(userid);
        }
        return -1L;
    }

    public int getNumberOfUsers() {
        return this.interactionHistorySizes.size();
    }

    public long getDurationUseOfUser(int userid) {
        if (this.interactionHistoryRanges.containsKey(userid)) {
            List<Date> dateRange = this.interactionHistoryRanges.get(userid);
            return dateRange.get(endDatePosition).getTime() - dateRange.get(startDatePosition).getTime();
        }
        return -1L;
    }

    public int getSizeOfHistory(int userid) {
        if (this.interactionHistorySizes.containsKey(userid)) {
            return this.interactionHistorySizes.get(userid);
        }
        return -1;
    }

    @Override
    public List<String> getPlainTextReport() {
        ArrayList<String> report = new ArrayList<String>();
        report.add(Messages.DataOverviewCollector_Data_Overview);
        report.add(String.valueOf(Messages.DataOverviewCollector_Number_of_Users_) + this.interactionHistorySizes.keySet().size());
        for (Map.Entry<Integer, Integer> entry : this.interactionHistorySizes.entrySet()) {
            report.add(entry.getKey() + ": " + entry.getValue() + Messages.DataOverviewCollector_events);
            report.add(String.valueOf(InteractionEventClassifier.formatDuration(this.interactionHistoryActiveDuration.get(entry.getKey()))) + Messages.DataOverviewCollector_active_use);
            List<Date> dateRange = this.interactionHistoryRanges.get(entry.getKey());
            long duration = dateRange.get(endDatePosition).getTime() - dateRange.get(startDatePosition).getTime();
            report.add(MessageFormat.format(Messages.DataOverviewCollector_TO_PERIOD_OF_HOURS, dateRange.get(startDatePosition), dateRange.get(endDatePosition), InteractionEventClassifier.formatDuration(duration)));
        }
        return report;
    }
}

