/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.discovery;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class UmlDiscoveryActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.obeonetwork.dsl.uml2.discovery";
    private static UmlDiscoveryActivator plugin;
    private final ServiceTracker<?, ?> proxyTracker = new ServiceTracker(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext(), IProxyService.class.getName(), null);

    public UmlDiscoveryActivator() {
        this.proxyTracker.open();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.proxyTracker.close();
        plugin = null;
        super.stop(context);
    }

    public static UmlDiscoveryActivator getDefault() {
        return plugin;
    }

    public void prepareProxySettings(String uriString) {
        try {
            IProxyData[] proxyDataForHost;
            URI uri = new URI(uriString);
            IProxyService proxyService = UmlDiscoveryActivator.getDefault().getProxyService();
            IProxyData[] iProxyDataArray = proxyDataForHost = proxyService.select(uri);
            int n = proxyDataForHost.length;
            int n2 = 0;
            while (n2 < n) {
                IProxyData data = iProxyDataArray[n2];
                if (data.getHost() != null) {
                    System.setProperty("http.proxySet", "true");
                    System.setProperty("http.proxyHost", data.getHost());
                }
                if (data.getHost() != null) {
                    System.setProperty("http.proxyPort", String.valueOf(data.getPort()));
                }
                ++n2;
            }
            proxyService = null;
        }
        catch (URISyntaxException e) {
            this.getLog().log((IStatus)new Status(2, PLUGIN_ID, e.getMessage(), (Throwable)e));
        }
    }

    public IProxyService getProxyService() {
        return (IProxyService)this.proxyTracker.getService();
    }
}

