/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.discovery.handlers;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.amalgam.discovery.DiscoveryDefinition;
import org.eclipse.amalgam.discovery.core.CancellableXMIResourceImpl;
import org.eclipse.amalgam.discovery.ui.viewer.DiscoveryContentProvider;
import org.eclipse.amalgam.discovery.ui.wizards.DiscoveryWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.obeonetwork.dsl.uml2.discovery.UmlDiscoveryActivator;

public class UmlDiscovery
extends DiscoveryContentProvider {
    private static final String CATALOG_URI = "http://obeonetwork.github.io/UML-Designer/discovery.xmi";

    public DiscoveryDefinition load(IProgressMonitor monitor) throws InterruptedException {
        DiscoveryDefinition result;
        URI catalogURI = URI.createURI((String)CATALOG_URI);
        UmlDiscoveryActivator.getDefault().prepareProxySettings(CATALOG_URI);
        CancellableXMIResourceImpl res = new CancellableXMIResourceImpl(catalogURI, monitor);
        try {
            res.load(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            this.errorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), e);
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        this.disco = result = (DiscoveryDefinition)res.getContents().get(0);
        return result;
    }

    private void errorDialog(IWorkbenchWindow window, Exception e) {
        String message = "We can't connect to the discovery source: \nhttp://obeonetwork.github.io/UML-Designer/discovery.xmi\n Make sure you're connected to internet and try again.";
        MessageDialog.openError((Shell)window.getShell(), (String)"Can't connect to discovery source", (String)message);
        throw new RuntimeException(e);
    }

    public String getDescription() {
        return "Pick a UML component to install it.";
    }

    public String getTitle() {
        return "Eclipse UML Components Discovery";
    }

    public static void openUmlDiscoveryWizard(IWorkbenchWindow window) {
        final UmlDiscovery provider = new UmlDiscovery();
        IWorkbench wb = PlatformUI.getWorkbench();
        IProgressService ps = wb.getProgressService();
        try {
            ps.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) {
                    try {
                        provider.load(pm);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
            if (provider.getDiscovery() != null) {
                DiscoveryWizard wizard = new DiscoveryWizard((DiscoveryContentProvider)provider);
                WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
                dialog.setMinimumPageSize(600, 400);
                dialog.open();
            }
        }
        catch (InvocationTargetException e1) {
            if (!(e1.getCause() instanceof OperationCanceledException)) {
                UmlDiscoveryActivator.getDefault().getLog().log((IStatus)new Status(4, "org.obeonetwork.dsl.uml2.discovery", e1.getMessage(), (Throwable)e1));
            }
        }
        catch (InterruptedException interruptedException) {}
    }
}

