/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.uc002;

import java.io.File;
import java.math.BigDecimal;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.tests.reqif10.serialization.util.AbstractTestCase;
import org.eclipse.rmf.tests.reqif10.serialization.util.TC9000ModelBuilder;
import org.junit.Test;

public class TC9000SimpleContentPerformanceTests
extends AbstractTestCase {
    private static final String WORKING_DIRECTORY = "work";

    @Test
    public void testSpecObject() throws Exception {
        int i = 1;
        while (i < 10000) {
            String fileName = "TC9000_SimpleContent_PerformanceTests_SpecObjects_" + i + ".reqif";
            ReqIF reqif = new TC9000ModelBuilder(null, "ID_" + fileName, fileName, i).getReqIF();
            TC9000SimpleContentPerformanceTests.saveReqIFFile((EObject)reqif, "work/" + fileName);
            this.doTest(fileName);
            i *= 2;
        }
    }

    private void doTest(String filename) throws Exception {
        System.out.println("Loading '" + filename + "'...");
        long totaltime = 0L;
        int i = 0;
        while (i < 3) {
            long start = System.currentTimeMillis();
            TC9000SimpleContentPerformanceTests.loadReqIFFile("work/" + filename);
            long end = System.currentTimeMillis();
            totaltime += end - start;
            ++i;
        }
        double size = new File("work/" + filename).length() / 1024L;
        double avgtime = totaltime / 3L;
        double timeperkb = new BigDecimal(avgtime / size).setScale(3, 0).doubleValue();
        System.out.println("Avg. time taken for '" + filename + "' with size " + size + "KB: " + avgtime / 1000.0 + "s");
        System.out.println("Time per KB: " + timeperkb + "ms");
    }
}

