/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelEvent;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelListener;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractAttributeEditor {
    public static final String KEY_TASK_ATTRIBUTE = "org.eclipse.mylyn.tasks.ui.editors.TaskAttribute";
    private Control control;
    private boolean decorationEnabled;
    private Label labelControl;
    private LayoutHint layoutHint;
    private final TaskDataModel dataModel;
    private final TaskAttribute taskAttribute;
    private boolean readOnly;
    private String description;
    private boolean refreshInProgress;
    private final TaskDataModelListener modelListener = new TaskDataModelListener(){

        public void attributeChanged(TaskDataModelEvent event) {
            if (AbstractAttributeEditor.this.getTaskAttribute().equals((Object)event.getTaskAttribute())) {
                block8: {
                    try {
                        try {
                            if (AbstractAttributeEditor.this.shouldAutoRefresh()) {
                                AbstractAttributeEditor.this.refreshInProgress = true;
                                AbstractAttributeEditor.this.refresh();
                            }
                            AbstractAttributeEditor.this.updateRequiredDecoration();
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            AbstractAttributeEditor.this.refreshInProgress = false;
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        AbstractAttributeEditor.this.refreshInProgress = false;
                        throw throwable;
                    }
                    AbstractAttributeEditor.this.refreshInProgress = false;
                }
                String changedAttribute = event.getTaskAttribute().getId();
                for (TaskAttribute taskAttribute : event.getTaskAttribute().getTaskData().getRoot().getAttributes().values()) {
                    if (!changedAttribute.equals(taskAttribute.getMetaData().getDependsOn())) continue;
                    event.getModel().attributeChanged(taskAttribute);
                }
            }
        }
    };
    private final DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            AbstractAttributeEditor.this.getModel().removeModelListener(AbstractAttributeEditor.this.modelListener);
        }
    };
    private final DisposeListener disposeDecorationListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (AbstractAttributeEditor.this.decoration != null) {
                AbstractAttributeEditor.this.decoration.dispose();
                AbstractAttributeEditor.this.decoration = null;
            }
        }
    };
    private ControlDecoration decoration;

    public AbstractAttributeEditor(@NonNull TaskDataModel dataModel, @NonNull TaskAttribute taskAttribute) {
        Assert.isNotNull((Object)dataModel);
        Assert.isNotNull((Object)taskAttribute);
        this.dataModel = dataModel;
        this.taskAttribute = taskAttribute;
        this.setDecorationEnabled(true);
        this.setReadOnly(taskAttribute.getMetaData().isReadOnly());
        this.setDescription(taskAttribute.getMetaData().getValue("task.meta.description"));
    }

    protected void attributeChanged() {
        if (!this.refreshInProgress) {
            this.getModel().attributeChanged(this.getTaskAttribute());
        }
    }

    public abstract void createControl(@NonNull Composite var1, @NonNull FormToolkit var2);

    public void createLabelControl(@NonNull Composite composite, @NonNull FormToolkit toolkit) {
        this.labelControl = toolkit.createLabel(composite, this.getLabel());
        this.labelControl.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
    }

    @Deprecated
    public void dispose() {
    }

    @NonNull
    public TaskDataModel getModel() {
        return this.dataModel;
    }

    @NonNull
    protected TaskAttributeMapper getAttributeMapper() {
        return this.getModel().getTaskData().getAttributeMapper();
    }

    @Nullable
    public Control getControl() {
        return this.control;
    }

    @NonNull
    public String getLabel() {
        String label = this.getAttributeMapper().getLabel(this.getTaskAttribute());
        return label != null ? LegacyActionTools.escapeMnemonics((String)label) : "";
    }

    @Nullable
    public Label getLabelControl() {
        return this.labelControl;
    }

    @Nullable
    public LayoutHint getLayoutHint() {
        return this.layoutHint;
    }

    @NonNull
    public TaskAttribute getTaskAttribute() {
        return this.taskAttribute;
    }

    public boolean hasLabel() {
        return true;
    }

    public boolean isDecorationEnabled() {
        return this.decorationEnabled;
    }

    protected void setControl(@Nullable Control control) {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.removeDisposeListener(this.disposeListener);
            this.getModel().removeModelListener(this.modelListener);
        }
        this.control = control;
        if (control != null) {
            control.setData(KEY_TASK_ATTRIBUTE, (Object)this.taskAttribute);
            control.addDisposeListener(this.disposeListener);
            this.getModel().addModelListener(this.modelListener);
        }
    }

    public void setDecorationEnabled(boolean decorationEnabled) {
        this.decorationEnabled = decorationEnabled;
    }

    public void setLayoutHint(@Nullable LayoutHint layoutHint) {
        this.layoutHint = layoutHint;
    }

    public void decorate(@Nullable Color color) {
        if (this.isDecorationEnabled()) {
            if (this.dataModel.hasBeenRead() && this.dataModel.hasIncomingChanges(this.getTaskAttribute())) {
                this.decorateIncoming(color);
            }
            if (this.dataModel.hasOutgoingChanges(this.getTaskAttribute())) {
                this.decorateOutgoing(color);
            }
            this.updateRequiredDecoration();
        }
    }

    private void updateRequiredDecoration() {
        if (this.getLabelControl() != null) {
            if (this.needsValue()) {
                this.decorateRequired();
            } else if (this.decoration != null) {
                this.decoration.hide();
                this.decoration.dispose();
                this.decoration = null;
                this.getLabelControl().removeDisposeListener(this.disposeDecorationListener);
            }
        }
    }

    protected void decorateRequired() {
        if (this.decoration == null) {
            this.decoration = new ControlDecoration((Control)this.getLabelControl(), 132096);
            this.decoration.setDescriptionText(Messages.AbstractAttributeEditor_AttributeIsRequired);
            this.decoration.setMarginWidth(0);
            Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
            this.decoration.setImage(image);
            this.getLabelControl().addDisposeListener(this.disposeDecorationListener);
        }
    }

    protected boolean needsValue() {
        boolean hasValue;
        boolean isRequired = this.getTaskAttribute().getMetaData().isRequired();
        boolean bl = hasValue = !StringUtils.isEmpty((String)this.getAttributeMapper().getValue(this.getTaskAttribute()));
        return isRequired && !hasValue;
    }

    protected void decorateOutgoing(@Nullable Color color) {
        if (this.labelControl != null) {
            this.labelControl.setText("*" + this.labelControl.getText());
        }
    }

    protected void decorateIncoming(@Nullable Color color) {
        if (this.getControl() != null) {
            this.getControl().setBackground(color);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void refresh() {
        throw new UnsupportedOperationException();
    }

    protected boolean shouldAutoRefresh() {
        return false;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    protected void updateLabel() {
        Label labelControl = this.getLabelControl();
        if (labelControl != null && !labelControl.isDisposed()) {
            labelControl.setText(this.getLabel());
        }
    }
}

