/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.api.accessor;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.AbstractMetamodelExtender;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ExtensionFeatureDescription;
import org.eclipse.sirius.ecore.extender.business.api.accessor.IMetamodelExtender;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.internal.common.ExtenderDescriptor;
import org.eclipse.sirius.ext.emf.EReferencePredicate;

public class CompositeMetamodelExtender
extends AbstractMetamodelExtender {
    private List<ExtenderDescriptor> extenderDescs = Lists.newArrayList();
    private List<IMetamodelExtender> extenders = Lists.newArrayList();
    private Iterable<IMetamodelExtender> activeExtenders;
    private Collection<? extends MetamodelDescriptor> metamodelDescriptors = Collections.emptyList();

    public void add(IMetamodelExtender ext, int priority) {
        this.extenderDescs.add(new ExtenderDescriptor(ext, priority));
        Collections.sort(this.extenderDescs);
        this.extenders.clear();
        for (ExtenderDescriptor desc : this.extenderDescs) {
            this.extenders.add(desc.getExtender());
        }
        if (this.isActive()) {
            ext.activate();
            ext.updateMetamodels(this.metamodelDescriptors);
        }
    }

    protected Iterator<IMetamodelExtender> getExtenders() {
        return this.extenders.iterator();
    }

    @Override
    public void init(ResourceSet set) {
        for (IMetamodelExtender extender : this.extenders) {
            extender.init(set);
        }
    }

    public TreeIterator<EObject> eAllContents(EObject root) {
        return new AbstractTreeIterator<EObject>((Object)root, false){
            private static final long serialVersionUID = 1L;

            public Iterator<EObject> getChildren(Object object) {
                if (object instanceof EObject) {
                    return CompositeMetamodelExtender.this.eContents((EObject)object);
                }
                return Collections.emptyList().iterator();
            }
        };
    }

    @Override
    public EObject createInstance(String name) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            EObject instance = extender.createInstance(name);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    @Override
    public boolean eIsKnownType(String name) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            boolean isKnown = extender.eIsKnownType(name);
            if (!isKnown) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        for (IMetamodelExtender extender : this.extenders) {
            if (this.isActive()) {
                extender.deactivate();
            }
            extender.dispose();
        }
    }

    @Override
    public Object eAdd(EObject instance, String name, Object value) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            Object addedValue = extender.eAdd(instance, name, value);
            if (addedValue == null) continue;
            return addedValue;
        }
        return null;
    }

    @Override
    public Object eClear(EObject instance, String name) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            Object clearedInstance = extender.eClear(instance, name);
            if (clearedInstance == null) continue;
            return clearedInstance;
        }
        return null;
    }

    @Override
    public EObject eContainer(EObject instance) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            EObject eContainer = extender.eContainer(instance);
            if (eContainer == null) continue;
            return eContainer;
        }
        return null;
    }

    @Override
    public String eContainingFeatureName(EObject instance) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            String feature = extender.eContainingFeatureName(instance);
            if (feature == null) continue;
            return feature;
        }
        return null;
    }

    @Override
    public Iterator<EObject> eContents(EObject root) {
        ArrayList iterators = Lists.newArrayList();
        IMetamodelExtender browsingBlocker = this.hasBrowsingBlocker(root);
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            if (browsingBlocker != null && extender != browsingBlocker) continue;
            iterators.add(extender.eContents(root));
        }
        if (!iterators.isEmpty()) {
            return Iterators.concat(iterators.iterator());
        }
        return Collections.emptyList().iterator();
    }

    private IMetamodelExtender hasBrowsingBlocker(EObject root) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            if (!extender.preventFromBrowsing(root)) continue;
            return extender;
        }
        return null;
    }

    @Override
    public EObject eDelete(EObject objectToRemove, ECrossReferenceAdapter xref) {
        return this.eDelete(objectToRemove, xref, null);
    }

    @Override
    public EObject eDelete(EObject objectToRemove, ECrossReferenceAdapter xref, EReferencePredicate isReferencesToIgnorePredicate) {
        EObject result = null;
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            result = extender.eDelete(objectToRemove, xref, isReferencesToIgnorePredicate);
        }
        return result;
    }

    @Override
    public void eRemoveInverseCrossReferences(EObject eObject, ECrossReferenceAdapter xref, EReferencePredicate isReferencesToIgnorePredicate) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            extender.eRemoveInverseCrossReferences(eObject, xref, isReferencesToIgnorePredicate);
        }
    }

    @Override
    public Object eGet(EObject instance, String name) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            Object result = extender.eGet(instance, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean eInstanceOf(EObject instance, String typeName) {
        if (typeName != null) {
            for (IMetamodelExtender extender : this.getActivatedExtenders()) {
                if (!extender.eInstanceOf(instance, typeName.trim())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean eIsContainment(EObject instance, String featureName) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            Boolean result = extender.eIsContainment(instance, featureName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Boolean eIsMany(EObject instance, String featureName) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            Boolean result = extender.eIsMany(instance, featureName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Object eRemove(EObject instance, String name, Object value) {
        Object result = null;
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            result = extender.eRemove(instance, name, value);
        }
        return result;
    }

    @Override
    public Object eSet(EObject instance, String name, Object value) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            Object result = extender.eSet(instance, name, value);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean eValid(EObject object, String name) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            if (!extender.eValid(object, name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<String> getContributedAttributeNames(EObject next) {
        ArrayList iterators = Lists.newArrayList();
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            iterators.add(extender.getContributedAttributeNames(next));
        }
        return Iterators.concat(iterators.iterator());
    }

    @Override
    public Iterator<String> getContributedReferenceNames(EObject instance) {
        ArrayList iterators = Lists.newArrayList();
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            iterators.add(extender.getContributedReferenceNames(instance));
        }
        return Iterators.concat(iterators.iterator());
    }

    @Override
    public boolean hasExtension(EObject next) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            if (!extender.hasExtension(next)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExtension(EObject next) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            if (!extender.isExtension(next)) continue;
            return true;
        }
        return false;
    }

    public Collection<EObject> eAllContents(EObject target, String typeName) {
        ArrayList result = Lists.newArrayList();
        TreeIterator<EObject> it = this.eAllContents(target);
        while (it.hasNext()) {
            EObject cur = (EObject)it.next();
            if (!this.eInstanceOf(cur, typeName)) continue;
            result.add(cur);
        }
        return result;
    }

    @Override
    public boolean isExtension(EObject next, String name) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            if (!extender.isExtension(next, name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getQualifiedName(EObject element, boolean b) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            String result = extender.getQualifiedName(element, b);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Collection<ExtensionFeatureDescription> getAllExtensionFeatureDescriptions(EObject target) {
        ArrayList result = Lists.newArrayList();
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            result.addAll(extender.getAllExtensionFeatureDescriptions(target));
        }
        return result;
    }

    @Override
    public boolean preventFromBrowsing(EObject root) {
        for (IMetamodelExtender extender : this.getActivatedExtenders()) {
            if (!extender.preventFromBrowsing(root)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateMetamodels(Collection<? extends MetamodelDescriptor> mmDescriptors) {
        super.updateMetamodels(mmDescriptors);
        this.metamodelDescriptors = mmDescriptors;
        for (IMetamodelExtender extender : this.extenders) {
            extender.updateMetamodels(this.metamodelDescriptors);
        }
    }

    @Override
    public void activate() {
        super.activate();
        for (IMetamodelExtender extender : this.extenders) {
            extender.activate();
        }
    }

    @Override
    public void deactivate() {
        for (IMetamodelExtender extender : this.extenders) {
            extender.deactivate();
        }
    }

    protected synchronized Iterable<IMetamodelExtender> getActivatedExtenders() {
        if (this.activeExtenders == null) {
            this.activeExtenders = Iterables.filter(this.extenders, (Predicate)new Predicate<IMetamodelExtender>(){

                public boolean apply(IMetamodelExtender extender) {
                    return extender.isActive();
                }
            });
        }
        return this.activeExtenders;
    }
}

