/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.internal.accessor.ecore;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.AbstractMetamodelExtender;
import org.eclipse.sirius.ecore.extender.business.api.accessor.EcoreMetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ExtensionFeatureDescription;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.internal.accessor.ecore.EMFUtil;
import org.eclipse.sirius.ecore.extender.business.internal.accessor.ecore.PackageRegistryIndex;
import org.eclipse.sirius.ext.emf.EReferencePredicate;

public class EcoreIntrinsicExtender
extends AbstractMetamodelExtender {
    private static final String SEPARATOR = ".";
    private static PackageRegistryIndex platformIndex = new PackageRegistryIndex(EPackage.Registry.INSTANCE, (Predicate<EPackage>)Predicates.alwaysTrue());
    private Multimap<String, EClass> viewpointIndex = HashMultimap.create();
    private Collection<? extends MetamodelDescriptor> lastDescriptors;

    @Override
    public EObject createInstance(String name) {
        URI eClassURI;
        EObject eobj;
        EObject result = null;
        Iterator<EClass> it = this.getEClassesFromName(name);
        while (result == null && it.hasNext()) {
            EClass eClass = it.next();
            if (eClass.isAbstract()) continue;
            result = EcoreUtil.create((EClass)eClass);
        }
        if (result == null && name != null && name.indexOf("#") > 0 && (eobj = new ResourceSetImpl().getEObject(eClassURI = URI.createURI((String)name), true)) instanceof EClass) {
            result = EcoreUtil.create((EClass)((EClass)eobj));
        }
        return result;
    }

    @Override
    public boolean eIsKnownType(String name) {
        return this.findFirstEClassFromName(name) != null;
    }

    @Override
    public Object eAdd(EObject instance, String name, Object value) {
        if (this.eValid(instance, name)) {
            if (this.eIsMany(instance, name).booleanValue()) {
                Object object = instance.eGet(instance.eClass().getEStructuralFeature(name));
                if (object instanceof Collection && value instanceof Collection) {
                    ((Collection)object).addAll((Collection)value);
                } else if (object instanceof Collection && value != null) {
                    ((Collection)object).add(value);
                }
            } else {
                this.eSet(instance, name, value);
            }
            return instance;
        }
        return null;
    }

    @Override
    public Iterator<EObject> eContents(EObject root) {
        return root.eContents().iterator();
    }

    @Override
    public Object eClear(EObject instance, String name) {
        if (this.eValid(instance, name)) {
            EStructuralFeature feat = instance.eClass().getEStructuralFeature(name);
            Object value = instance.eGet(feat);
            if (value != null) {
                if (value instanceof Collection) {
                    ((Collection)value).clear();
                } else {
                    instance.eSet(feat, null);
                }
            }
            return instance;
        }
        return null;
    }

    @Override
    public EObject eContainer(EObject instance) {
        return instance.eContainer();
    }

    @Override
    public String eContainingFeatureName(EObject objectToRemove) {
        if (objectToRemove.eContainingFeature() != null) {
            return objectToRemove.eContainingFeature().getName();
        }
        return null;
    }

    @Override
    public EObject eDelete(EObject objectToRemove, ECrossReferenceAdapter xref) {
        return this.eDelete(objectToRemove, xref, null);
    }

    @Override
    public EObject eDelete(EObject objectToRemove, ECrossReferenceAdapter xref, EReferencePredicate isReferencesToIgnorePredicate) {
        if (xref == null) {
            EcoreUtil.delete((EObject)objectToRemove);
        } else {
            this.eRemoveInverseCrossReferences(objectToRemove, xref, isReferencesToIgnorePredicate);
            EcoreUtil.remove((EObject)objectToRemove);
        }
        return objectToRemove;
    }

    @Override
    public void eRemoveInverseCrossReferences(EObject eObject, ECrossReferenceAdapter xref, EReferencePredicate isReferencesToIgnorePredicate) {
        boolean isFeatureToIgnore;
        boolean isChangeableFeature;
        Collection inverseReferences = xref.getInverseReferences(eObject, true);
        Collection<EStructuralFeature.Setting> containmentReferences = this.getContainmentReferences(inverseReferences);
        Collection<EStructuralFeature.Setting> otherReferences = this.getNonContainmentReferences(inverseReferences);
        for (EStructuralFeature.Setting setting : otherReferences) {
            isChangeableFeature = setting.getEStructuralFeature().isChangeable();
            boolean bl = isFeatureToIgnore = isReferencesToIgnorePredicate != null && setting.getEStructuralFeature() instanceof EReference && isReferencesToIgnorePredicate.apply((EReference)setting.getEStructuralFeature());
            if (!isChangeableFeature || isFeatureToIgnore) continue;
            EcoreUtil.remove((EStructuralFeature.Setting)setting, (Object)eObject);
        }
        for (EStructuralFeature.Setting setting : containmentReferences) {
            isChangeableFeature = setting.getEStructuralFeature().isChangeable();
            boolean bl = isFeatureToIgnore = isReferencesToIgnorePredicate != null && setting.getEStructuralFeature() instanceof EReference && isReferencesToIgnorePredicate.apply((EReference)setting.getEStructuralFeature());
            if (!isChangeableFeature || isFeatureToIgnore) continue;
            EcoreUtil.remove((EStructuralFeature.Setting)setting, (Object)eObject);
        }
    }

    private Collection<EStructuralFeature.Setting> getContainmentReferences(Collection<EStructuralFeature.Setting> inverseReferences) {
        ArrayList<EStructuralFeature.Setting> containmentReferences = new ArrayList<EStructuralFeature.Setting>();
        for (EStructuralFeature.Setting setting : inverseReferences) {
            EReference eReference;
            EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
            if (!(eStructuralFeature instanceof EReference) || !(eReference = (EReference)eStructuralFeature).isContainment()) continue;
            containmentReferences.add(setting);
        }
        return containmentReferences;
    }

    private Collection<EStructuralFeature.Setting> getNonContainmentReferences(Collection<EStructuralFeature.Setting> inverseReferences) {
        ArrayList<EStructuralFeature.Setting> containmentReferences = new ArrayList<EStructuralFeature.Setting>();
        for (EStructuralFeature.Setting setting : inverseReferences) {
            EReference eReference;
            EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
            if (!(eStructuralFeature instanceof EReference) || (eReference = (EReference)eStructuralFeature).isContainment()) continue;
            containmentReferences.add(setting);
        }
        return containmentReferences;
    }

    @Override
    public Object eGet(EObject instance, String name) {
        if (instance.eClass().getEStructuralFeature(name) != null) {
            return instance.eGet(instance.eClass().getEStructuralFeature(name));
        }
        return null;
    }

    @Override
    public boolean eInstanceOf(EObject instance, String name) {
        if ("EObject".equals(name) && instance != null) {
            return true;
        }
        boolean result = this.eInstanceOf(instance.eClass(), name);
        if (!result && name != null && name.indexOf("#") > 0) {
            try {
                URI eClassURI = URI.createURI((String)name);
                EObject eobj = new ResourceSetImpl().getEObject(eClassURI, true);
                if (eobj instanceof EClass) {
                    result = ((EClass)eobj).isInstance((Object)instance);
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private boolean eInstanceOf(EClass eClass, String superClassName) {
        boolean result = false;
        if (eClass.getName().equals(superClassName)) {
            return true;
        }
        Iterator<EClass> it = this.getEClassesFromName(superClassName);
        while (!result && it.hasNext()) {
            EClass possibleSuperType = it.next();
            result = possibleSuperType.isSuperTypeOf(eClass);
        }
        return result;
    }

    @Override
    public Boolean eIsContainment(EObject instance, String featureName) {
        Boolean result = null;
        if (instance.eClass().getEStructuralFeature(featureName) instanceof EReference) {
            result = new Boolean(((EReference)instance.eClass().getEStructuralFeature(featureName)).isContainment());
        }
        if (result == null && instance.eClass().getEStructuralFeature(featureName) instanceof EAttribute) {
            result = Boolean.TRUE;
        }
        return result;
    }

    @Override
    public Boolean eIsMany(EObject instance, String featureName) {
        if (instance.eClass().getEStructuralFeature(featureName) != null) {
            return new Boolean(instance.eClass().getEStructuralFeature(featureName).isMany());
        }
        return null;
    }

    @Override
    public Object eRemove(EObject instance, String name, Object value) {
        if (this.eValid(instance, name)) {
            EcoreUtil.remove((EObject)instance, (EStructuralFeature)instance.eClass().getEStructuralFeature(name), (Object)value);
            return value;
        }
        return null;
    }

    @Override
    public Object eSet(EObject instance, String name, Object value) {
        if (this.eValid(instance, name)) {
            EStructuralFeature feature = instance.eClass().getEStructuralFeature(name);
            if (feature.getEType() instanceof EEnum && (value instanceof String || value instanceof Integer)) {
                EEnumLiteral literal = this.getEnumLiteral((EEnum)feature.getEType(), value);
                if (literal != null) {
                    instance.eSet(feature, (Object)literal.getInstance());
                }
            } else if (feature instanceof EAttribute && value instanceof String) {
                EDataType attributeType = ((EAttribute)feature).getEAttributeType();
                Object objectValue = EcoreUtil.createFromString((EDataType)attributeType, (String)((String)value));
                instance.eSet(feature, objectValue);
            } else {
                instance.eSet(feature, value);
            }
            return instance;
        }
        return null;
    }

    private EEnumLiteral getEnumLiteral(EEnum eenum, Object value) {
        EEnumLiteral literal = null;
        if (value instanceof Integer) {
            literal = eenum.getEEnumLiteral(((Integer)value).intValue());
        } else if (value instanceof String && (literal = eenum.getEEnumLiteral((String)value)) == null) {
            literal = eenum.getEEnumLiteralByLiteral((String)value);
        }
        return literal;
    }

    @Override
    public boolean eValid(EObject object, String name) {
        return object.eClass().getEStructuralFeature(name) != null;
    }

    @Override
    public Iterator<String> getContributedAttributeNames(EObject next) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (EAttribute attr : next.eClass().getEAllAttributes()) {
            attributeNames.add(attr.getName());
        }
        return attributeNames.iterator();
    }

    @Override
    public Iterator<String> getContributedReferenceNames(EObject instance) {
        ArrayList<String> referencesNames = new ArrayList<String>();
        for (EReference ref : instance.eClass().getEAllReferences()) {
            referencesNames.add(ref.getName());
        }
        return referencesNames.iterator();
    }

    @Override
    public boolean hasExtension(EObject next) {
        return false;
    }

    @Override
    public void init(ResourceSet set) {
    }

    private void addTypesToSiriusIndex(EPackage value) {
        for (EClass cur : Iterables.filter((Iterable)value.getEClassifiers(), EClass.class)) {
            this.viewpointIndex.put((Object)cur.getName(), (Object)cur);
            this.viewpointIndex.put((Object)(String.valueOf(value.getName()) + SEPARATOR + cur.getName()), (Object)cur);
        }
    }

    @Override
    public boolean isExtension(EObject next) {
        return false;
    }

    private Iterator<EClass> getEClassesFromName(String name) {
        return Iterators.concat(this.viewpointIndex.get((Object)name).iterator(), platformIndex.getEClassesFromName(name).iterator());
    }

    private EClass findFirstEClassFromName(String name) {
        Iterator<EClass> it = this.getEClassesFromName(name);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public EObject createInstance(EClass eClass) {
        return EcoreUtil.create((EClass)eClass);
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getQualifiedName(EObject element, boolean b) {
        return EMFUtil.getQualifiedName(element, b);
    }

    @Override
    public boolean isExtension(EObject next, String name) {
        return false;
    }

    @Override
    public Collection<ExtensionFeatureDescription> getAllExtensionFeatureDescriptions(EObject target) {
        return Collections.emptyList();
    }

    @Override
    public boolean preventFromBrowsing(EObject root) {
        return false;
    }

    @Override
    public void updateMetamodels(Collection<? extends MetamodelDescriptor> metamodelDescriptors) {
        if (this.lastDescriptors != null) {
            metamodelDescriptors.removeAll(this.lastDescriptors);
        }
        for (MetamodelDescriptor metamodelDescriptor : metamodelDescriptors) {
            EPackage pak;
            if (!(metamodelDescriptor instanceof EcoreMetamodelDescriptor) || (pak = ((EcoreMetamodelDescriptor)metamodelDescriptor).resolve()) == null) continue;
            this.addTypesToSiriusIndex(pak);
            UnmodifiableIterator subPack = Iterators.filter((Iterator)pak.eAllContents(), EPackage.class);
            while (subPack.hasNext()) {
                this.addTypesToSiriusIndex((EPackage)subPack.next());
            }
        }
        this.lastDescriptors = metamodelDescriptors;
    }
}

