/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.internal.common;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.sirius.ecore.extender.business.internal.permission.PermissionService;

public abstract class AbstractProviderDescriptor
implements Comparable<AbstractProviderDescriptor> {
    protected int priority = 5;
    protected String providerClassName;
    protected final IConfigurationElement element;

    public AbstractProviderDescriptor(IConfigurationElement element) {
        this.element = element;
        this.providerClassName = this.getAttribute("providerClass", null);
        this.priority = PermissionService.getPriorityValue(this.getAttribute("priority", "low"));
    }

    private String getAttribute(String name, String defaultValue) {
        String value = this.element.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException("The " + name + " attribute is missing");
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(AbstractProviderDescriptor other) {
        int nombre1 = other.getPriority();
        int nombre2 = this.priority;
        return nombre2 - nombre1;
    }
}

