/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.datatypes.util;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.eclipse.rmf.reqif10.datatypes.DatatypesPackage;
import org.eclipse.rmf.reqif10.datatypes.FrameTargetMember0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypesValidator
extends EObjectValidator {
    public static final DatatypesValidator INSTANCE = new DatatypesValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.rmf.reqif10.datatypes";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;
    public static final EValidator.PatternMatcher[][] COLOR_MEMBER1__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"#[0-9a-fA-F]{3}([0-9a-fA-F]{3})?")}};
    public static final EValidator.PatternMatcher[][] CURIE__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"(([\\i-[:]][\\c-[:]]*)?:)?.+")}};
    public static final EValidator.PatternMatcher[][] FRAME_TARGET_MEMBER1__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"[a-zA-Z].*")}};
    public static final EValidator.PatternMatcher[][] LENGTH_MEMBER1__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"\\d+[%]|\\d*\\.\\d+[%]")}};
    public static final EValidator.PatternMatcher[][] MULTI_LENGTH_MEMBER1__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"\\d*\\*")}};
    public static final EValidator.PatternMatcher[][] SAFE_CURIE__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"\\[(([\\i-[:]][\\c-[:]]*)?:)?.+\\]")}};
    public static final EValidator.PatternMatcher[][] URIREF__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"#\\c*")}};

    protected EPackage getEPackage() {
        return DatatypesPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateFrameTargetMember0((FrameTargetMember0)((Object)value), diagnostics, context);
            }
            case 1: {
                return this.validateCDATA((String)value, diagnostics, context);
            }
            case 2: {
                return this.validateCharacter((String)value, diagnostics, context);
            }
            case 3: {
                return this.validateCharset((String)value, diagnostics, context);
            }
            case 4: {
                return this.validateCharsets((List)value, diagnostics, context);
            }
            case 5: {
                return this.validateColor((String)value, diagnostics, context);
            }
            case 6: {
                return this.validateColorMember1((String)value, diagnostics, context);
            }
            case 7: {
                return this.validateContentType((String)value, diagnostics, context);
            }
            case 8: {
                return this.validateContentTypes((String)value, diagnostics, context);
            }
            case 9: {
                return this.validateCURIE((String)value, diagnostics, context);
            }
            case 10: {
                return this.validateCURIEs((List)value, diagnostics, context);
            }
            case 11: {
                return this.validateDatetime((XMLGregorianCalendar)value, diagnostics, context);
            }
            case 12: {
                return this.validateFPI((String)value, diagnostics, context);
            }
            case 13: {
                return this.validateFrameTarget(value, diagnostics, context);
            }
            case 14: {
                return this.validateFrameTargetMember0Object((FrameTargetMember0)((Object)value), diagnostics, context);
            }
            case 15: {
                return this.validateFrameTargetMember1((String)value, diagnostics, context);
            }
            case 16: {
                return this.validateLanguageCode((String)value, diagnostics, context);
            }
            case 17: {
                return this.validateLanguageCodes((String)value, diagnostics, context);
            }
            case 18: {
                return this.validateLength(value, diagnostics, context);
            }
            case 19: {
                return this.validateLengthMember1((String)value, diagnostics, context);
            }
            case 20: {
                return this.validateLinkTypes((List)value, diagnostics, context);
            }
            case 21: {
                return this.validateMediaDesc((String)value, diagnostics, context);
            }
            case 22: {
                return this.validateMultiLength(value, diagnostics, context);
            }
            case 23: {
                return this.validateMultiLengthMember1((String)value, diagnostics, context);
            }
            case 24: {
                return this.validateMultiLengths((String)value, diagnostics, context);
            }
            case 25: {
                return this.validateNumber((BigInteger)value, diagnostics, context);
            }
            case 26: {
                return this.validatePixels((BigInteger)value, diagnostics, context);
            }
            case 27: {
                return this.validateSafeCURIE((String)value, diagnostics, context);
            }
            case 28: {
                return this.validateSafeCURIEs((List)value, diagnostics, context);
            }
            case 29: {
                return this.validateScript((String)value, diagnostics, context);
            }
            case 30: {
                return this.validateText((String)value, diagnostics, context);
            }
            case 31: {
                return this.validateURI((String)value, diagnostics, context);
            }
            case 32: {
                return this.validateURIorSafeCURIE((String)value, diagnostics, context);
            }
            case 33: {
                return this.validateURIorSafeCURIEs((List)value, diagnostics, context);
            }
            case 34: {
                return this.validateURIREF((String)value, diagnostics, context);
            }
            case 35: {
                return this.validateURIs((List)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateFrameTargetMember0(FrameTargetMember0 frameTargetMember0, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateCDATA(String cdata, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateCharacter(String character, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateCharacter_MinLength(character, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateCharacter_MaxLength(character, diagnostics, context);
        }
        return result;
    }

    public boolean validateCharacter_MinLength(String character, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = character.length();
        boolean bl = result = length >= 1;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(DatatypesPackage.Literals.CHARACTER, character, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validateCharacter_MaxLength(String character, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = character.length();
        boolean bl = result = length <= 1;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(DatatypesPackage.Literals.CHARACTER, character, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validateCharset(String charset, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateCharsets(List<?> charsets, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateCharsets_ItemType(charsets, diagnostics, context);
        return result;
    }

    public boolean validateCharsets_ItemType(List<?> charsets, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<?> i = charsets.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (DatatypesPackage.Literals.CHARSET.isInstance(item)) {
                result &= this.validateCharset((String)item, diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(DatatypesPackage.Literals.CHARSET, item, diagnostics, context);
        }
        return result;
    }

    public boolean validateColor(String color, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateColor_MemberTypes(color, diagnostics, context);
        return result;
    }

    public boolean validateColor_MemberTypes(String color, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            BasicDiagnostic tempDiagnostics = new BasicDiagnostic();
            if (XMLTypePackage.Literals.NMTOKEN.isInstance((Object)color) && this.xmlTypeValidator.validateNMTOKEN(color, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (DatatypesPackage.Literals.COLOR_MEMBER1.isInstance((Object)color) && this.validateColorMember1(color, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            for (Diagnostic diagnostic : tempDiagnostics.getChildren()) {
                diagnostics.add(diagnostic);
            }
        } else {
            if (XMLTypePackage.Literals.NMTOKEN.isInstance((Object)color) && this.xmlTypeValidator.validateNMTOKEN(color, null, context)) {
                return true;
            }
            if (DatatypesPackage.Literals.COLOR_MEMBER1.isInstance((Object)color) && this.validateColorMember1(color, null, context)) {
                return true;
            }
        }
        return false;
    }

    public boolean validateColorMember1(String colorMember1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateColorMember1_Pattern(colorMember1, diagnostics, context);
        return result;
    }

    public boolean validateColorMember1_Pattern(String colorMember1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validatePattern(DatatypesPackage.Literals.COLOR_MEMBER1, colorMember1, COLOR_MEMBER1__PATTERN__VALUES, diagnostics, context);
    }

    public boolean validateContentType(String contentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateContentTypes(String contentTypes, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateCURIE(String curie, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateCURIE_Pattern(curie, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateCURIE_MinLength(curie, diagnostics, context);
        }
        return result;
    }

    public boolean validateCURIE_Pattern(String curie, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validatePattern(DatatypesPackage.Literals.CURIE, curie, CURIE__PATTERN__VALUES, diagnostics, context);
    }

    public boolean validateCURIE_MinLength(String curie, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = curie.length();
        boolean bl = result = length >= 1;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(DatatypesPackage.Literals.CURIE, curie, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validateCURIEs(List<?> curiEs, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateCURIEs_ItemType(curiEs, diagnostics, context);
        return result;
    }

    public boolean validateCURIEs_ItemType(List<?> curiEs, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<?> i = curiEs.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (DatatypesPackage.Literals.CURIE.isInstance(item)) {
                result &= this.validateCURIE((String)item, diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(DatatypesPackage.Literals.CURIE, item, diagnostics, context);
        }
        return result;
    }

    public boolean validateDatetime(XMLGregorianCalendar datetime, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFPI(String fpi, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFrameTarget(Object frameTarget, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateFrameTarget_MemberTypes(frameTarget, diagnostics, context);
        return result;
    }

    public boolean validateFrameTarget_MemberTypes(Object frameTarget, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            BasicDiagnostic tempDiagnostics = new BasicDiagnostic();
            if (DatatypesPackage.Literals.FRAME_TARGET_MEMBER0.isInstance(frameTarget) && this.validateFrameTargetMember0((FrameTargetMember0)((Object)frameTarget), (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (DatatypesPackage.Literals.FRAME_TARGET_MEMBER1.isInstance(frameTarget) && this.validateFrameTargetMember1((String)frameTarget, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            for (Diagnostic diagnostic : tempDiagnostics.getChildren()) {
                diagnostics.add(diagnostic);
            }
        } else {
            if (DatatypesPackage.Literals.FRAME_TARGET_MEMBER0.isInstance(frameTarget) && this.validateFrameTargetMember0((FrameTargetMember0)((Object)frameTarget), null, context)) {
                return true;
            }
            if (DatatypesPackage.Literals.FRAME_TARGET_MEMBER1.isInstance(frameTarget) && this.validateFrameTargetMember1((String)frameTarget, null, context)) {
                return true;
            }
        }
        return false;
    }

    public boolean validateFrameTargetMember0Object(FrameTargetMember0 frameTargetMember0Object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFrameTargetMember1(String frameTargetMember1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateFrameTargetMember1_Pattern(frameTargetMember1, diagnostics, context);
        return result;
    }

    public boolean validateFrameTargetMember1_Pattern(String frameTargetMember1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validatePattern(DatatypesPackage.Literals.FRAME_TARGET_MEMBER1, frameTargetMember1, FRAME_TARGET_MEMBER1__PATTERN__VALUES, diagnostics, context);
    }

    public boolean validateLanguageCode(String languageCode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.xmlTypeValidator.validateLanguage_Pattern(languageCode, diagnostics, context);
        return result;
    }

    public boolean validateLanguageCodes(String languageCodes, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateLength(Object length, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateLength_MemberTypes(length, diagnostics, context);
        return result;
    }

    public boolean validateLength_MemberTypes(Object length, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            BasicDiagnostic tempDiagnostics = new BasicDiagnostic();
            if (XMLTypePackage.Literals.NON_NEGATIVE_INTEGER.isInstance(length) && this.xmlTypeValidator.validateNonNegativeInteger((BigInteger)length, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (DatatypesPackage.Literals.LENGTH_MEMBER1.isInstance(length) && this.validateLengthMember1((String)length, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            for (Diagnostic diagnostic : tempDiagnostics.getChildren()) {
                diagnostics.add(diagnostic);
            }
        } else {
            if (XMLTypePackage.Literals.NON_NEGATIVE_INTEGER.isInstance(length) && this.xmlTypeValidator.validateNonNegativeInteger((BigInteger)length, null, context)) {
                return true;
            }
            if (DatatypesPackage.Literals.LENGTH_MEMBER1.isInstance(length) && this.validateLengthMember1((String)length, null, context)) {
                return true;
            }
        }
        return false;
    }

    public boolean validateLengthMember1(String lengthMember1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateLengthMember1_Pattern(lengthMember1, diagnostics, context);
        return result;
    }

    public boolean validateLengthMember1_Pattern(String lengthMember1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validatePattern(DatatypesPackage.Literals.LENGTH_MEMBER1, lengthMember1, LENGTH_MEMBER1__PATTERN__VALUES, diagnostics, context);
    }

    public boolean validateLinkTypes(List<?> linkTypes, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateLinkTypes_ItemType(linkTypes, diagnostics, context);
        return result;
    }

    public boolean validateLinkTypes_ItemType(List<?> linkTypes, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<?> i = linkTypes.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (XMLTypePackage.Literals.NMTOKEN.isInstance(item)) {
                result &= this.xmlTypeValidator.validateNMTOKEN((String)item, diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(XMLTypePackage.Literals.NMTOKEN, item, diagnostics, context);
        }
        return result;
    }

    public boolean validateMediaDesc(String mediaDesc, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateMultiLength(Object multiLength, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateMultiLength_MemberTypes(multiLength, diagnostics, context);
        return result;
    }

    public boolean validateMultiLength_MemberTypes(Object multiLength, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            BasicDiagnostic tempDiagnostics = new BasicDiagnostic();
            if (DatatypesPackage.Literals.LENGTH.isInstance(multiLength) && this.validateLength(multiLength, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (DatatypesPackage.Literals.MULTI_LENGTH_MEMBER1.isInstance(multiLength) && this.validateMultiLengthMember1((String)multiLength, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            for (Diagnostic diagnostic : tempDiagnostics.getChildren()) {
                diagnostics.add(diagnostic);
            }
        } else {
            if (DatatypesPackage.Literals.LENGTH.isInstance(multiLength) && this.validateLength(multiLength, null, context)) {
                return true;
            }
            if (DatatypesPackage.Literals.MULTI_LENGTH_MEMBER1.isInstance(multiLength) && this.validateMultiLengthMember1((String)multiLength, null, context)) {
                return true;
            }
        }
        return false;
    }

    public boolean validateMultiLengthMember1(String multiLengthMember1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateMultiLengthMember1_Pattern(multiLengthMember1, diagnostics, context);
        return result;
    }

    public boolean validateMultiLengthMember1_Pattern(String multiLengthMember1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validatePattern(DatatypesPackage.Literals.MULTI_LENGTH_MEMBER1, multiLengthMember1, MULTI_LENGTH_MEMBER1__PATTERN__VALUES, diagnostics, context);
    }

    public boolean validateMultiLengths(String multiLengths, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateNumber(BigInteger number, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.xmlTypeValidator.validateNonNegativeInteger_Min(number, diagnostics, context);
        return result;
    }

    public boolean validatePixels(BigInteger pixels, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.xmlTypeValidator.validateNonNegativeInteger_Min(pixels, diagnostics, context);
        return result;
    }

    public boolean validateSafeCURIE(String safeCURIE, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateSafeCURIE_Pattern(safeCURIE, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateSafeCURIE_MinLength(safeCURIE, diagnostics, context);
        }
        return result;
    }

    public boolean validateSafeCURIE_Pattern(String safeCURIE, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validatePattern(DatatypesPackage.Literals.SAFE_CURIE, safeCURIE, SAFE_CURIE__PATTERN__VALUES, diagnostics, context);
    }

    public boolean validateSafeCURIE_MinLength(String safeCURIE, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = safeCURIE.length();
        boolean bl = result = length >= 3;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(DatatypesPackage.Literals.SAFE_CURIE, safeCURIE, length, 3, diagnostics, context);
        }
        return result;
    }

    public boolean validateSafeCURIEs(List<?> safeCURIEs, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateSafeCURIEs_ItemType(safeCURIEs, diagnostics, context);
        return result;
    }

    public boolean validateSafeCURIEs_ItemType(List<?> safeCURIEs, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<?> i = safeCURIEs.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (DatatypesPackage.Literals.SAFE_CURIE.isInstance(item)) {
                result &= this.validateSafeCURIE((String)item, diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(DatatypesPackage.Literals.SAFE_CURIE, item, diagnostics, context);
        }
        return result;
    }

    public boolean validateScript(String script, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateText(String text, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateURI(String uri, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateURIorSafeCURIE(String urIorSafeCURIE, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateURIorSafeCURIE_MemberTypes(urIorSafeCURIE, diagnostics, context);
        return result;
    }

    public boolean validateURIorSafeCURIE_MemberTypes(String urIorSafeCURIE, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            BasicDiagnostic tempDiagnostics = new BasicDiagnostic();
            if (XMLTypePackage.Literals.ANY_URI.isInstance((Object)urIorSafeCURIE) && this.xmlTypeValidator.validateAnyURI(urIorSafeCURIE, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (DatatypesPackage.Literals.SAFE_CURIE.isInstance((Object)urIorSafeCURIE) && this.validateSafeCURIE(urIorSafeCURIE, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            for (Diagnostic diagnostic : tempDiagnostics.getChildren()) {
                diagnostics.add(diagnostic);
            }
        } else {
            if (XMLTypePackage.Literals.ANY_URI.isInstance((Object)urIorSafeCURIE) && this.xmlTypeValidator.validateAnyURI(urIorSafeCURIE, null, context)) {
                return true;
            }
            if (DatatypesPackage.Literals.SAFE_CURIE.isInstance((Object)urIorSafeCURIE) && this.validateSafeCURIE(urIorSafeCURIE, null, context)) {
                return true;
            }
        }
        return false;
    }

    public boolean validateURIorSafeCURIEs(List<?> urIorSafeCURIEs, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateURIorSafeCURIEs_ItemType(urIorSafeCURIEs, diagnostics, context);
        return result;
    }

    public boolean validateURIorSafeCURIEs_ItemType(List<?> urIorSafeCURIEs, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<?> i = urIorSafeCURIEs.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (DatatypesPackage.Literals.UR_IOR_SAFE_CURIE.isInstance(item)) {
                result &= this.validateURIorSafeCURIE((String)item, diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(DatatypesPackage.Literals.UR_IOR_SAFE_CURIE, item, diagnostics, context);
        }
        return result;
    }

    public boolean validateURIREF(String uriref, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateURIREF_Pattern(uriref, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateURIREF_MinLength(uriref, diagnostics, context);
        }
        return result;
    }

    public boolean validateURIREF_Pattern(String uriref, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validatePattern(DatatypesPackage.Literals.URIREF, uriref, URIREF__PATTERN__VALUES, diagnostics, context);
    }

    public boolean validateURIREF_MinLength(String uriref, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = uriref.length();
        boolean bl = result = length >= 1;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(DatatypesPackage.Literals.URIREF, uriref, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validateURIs(List<?> urIs, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateURIs_ItemType(urIs, diagnostics, context);
        return result;
    }

    public boolean validateURIs_ItemType(List<?> urIs, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<?> i = urIs.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (XMLTypePackage.Literals.ANY_URI.isInstance(item)) {
                result &= this.xmlTypeValidator.validateAnyURI((String)item, diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(XMLTypePackage.Literals.ANY_URI, item, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

