/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide;

import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.obeonetwork.m2doc.ide.services.DeclaredServicesListener;
import org.obeonetwork.m2doc.ide.services.configurator.ServicesConfiguratorRegistryListener;
import org.obeonetwork.m2doc.ide.util.EclipseClassProvider;
import org.obeonetwork.m2doc.util.ClassProvider;
import org.obeonetwork.m2doc.util.IClassProvider;
import org.osgi.framework.BundleContext;

public class M2DocPlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "org.obeonetwork.m2doc";
    public static final M2DocPlugin INSTANCE = new M2DocPlugin();
    private static Implementation plugin;
    private static IClassProvider classProvider;

    static {
        classProvider = new ClassProvider(M2DocPlugin.class.getClassLoader());
    }

    public M2DocPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static IClassProvider getClassProvider() {
        return classProvider;
    }

    public static M2DocPlugin getDefault() {
        return INSTANCE;
    }

    public static void log(Exception exception, boolean blocker) {
        int severity = 2;
        if (blocker) {
            severity = 4;
        }
        INSTANCE.log(new Status(severity, PLUGIN_ID, exception.getMessage(), (Throwable)exception));
    }

    public static void log(String message, boolean blocker) {
        String errorMessage;
        int severity = 2;
        if (blocker) {
            severity = 4;
        }
        if ((errorMessage = message) == null || "".equals(errorMessage)) {
            errorMessage = "Logging null message should never happens.";
        }
        INSTANCE.log(new Status(severity, PLUGIN_ID, errorMessage));
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        private ServicesConfiguratorRegistryListener registryListener = new ServicesConfiguratorRegistryListener();
        private DeclaredServicesListener servicesListener = new DeclaredServicesListener();

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.addListener((IRegistryEventListener)this.registryListener, "org.obeonetwork.m2doc.ide.servicesConfigurator");
            this.registryListener.parseInitialContributions();
            registry.addListener((IRegistryEventListener)this.servicesListener, "org.obeonetwork.m2doc.ide.services.register");
            this.servicesListener.parseInitialContributions();
            classProvider = (IClassProvider)new EclipseClassProvider(context, ((Object)((Object)this)).getClass().getClassLoader());
        }

        public void stop(BundleContext context) throws Exception {
            super.stop(context);
            ((EclipseClassProvider)classProvider).dispose();
            classProvider = (IClassProvider)new ClassProvider(M2DocPlugin.class.getClassLoader());
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.removeListener((IRegistryEventListener)this.registryListener);
            registry.removeListener((IRegistryEventListener)this.servicesListener);
        }
    }
}

