/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.record;

import java.io.IOException;
import org.apache.poi.hemf.record.AbstractHemfComment;
import org.apache.poi.hemf.record.HemfComment;
import org.apache.poi.hemf.record.HemfCommentEMFPlus;
import org.apache.poi.hemf.record.HemfCommentEMFSpool;
import org.apache.poi.hemf.record.HemfCommentPublic;
import org.apache.poi.hemf.record.HemfRecord;
import org.apache.poi.hemf.record.HemfRecordType;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.RecordFormatException;

@Internal
public class HemfCommentRecord
implements HemfRecord {
    public static final long COMMENT_EMFSPOOL = 0L;
    public static final long COMMENT_EMFPLUS = 726027589L;
    public static final long COMMENT_PUBLIC = 1128875079L;
    private AbstractHemfComment comment;

    @Override
    public HemfRecordType getRecordType() {
        return HemfRecordType.comment;
    }

    @Override
    public long init(LittleEndianInputStream leis, long recordId, long recordSize) throws IOException {
        long dataSize = leis.readUInt();
        recordSize -= 4L;
        byte[] optionalCommentIndentifierBuffer = new byte[4];
        leis.readFully(optionalCommentIndentifierBuffer);
        long optionalCommentIdentifier = (long)LittleEndian.getInt(optionalCommentIndentifierBuffer) & 0xFFFFFFFFL;
        this.comment = optionalCommentIdentifier == 0L ? new HemfCommentEMFSpool(this.readToByteArray(leis, dataSize, recordSize)) : (optionalCommentIdentifier == 726027589L ? new HemfCommentEMFPlus(this.readToByteArray(leis, dataSize, recordSize)) : (optionalCommentIdentifier == 1128875079L ? CommentPublicParser.parse(this.readToByteArray(leis, dataSize, recordSize)) : new HemfComment(this.readToByteArray(optionalCommentIndentifierBuffer, leis, dataSize -= 4L, recordSize -= 4L))));
        return recordSize;
    }

    private byte[] readToByteArray(byte[] initialBytes, LittleEndianInputStream leis, long remainingDataSize, long remainingRecordSize) throws IOException {
        if (remainingDataSize > Integer.MAX_VALUE) {
            throw new RecordFormatException("Data size can't be > Integer.MAX_VALUE");
        }
        if (remainingRecordSize > Integer.MAX_VALUE) {
            throw new RecordFormatException("Record size can't be > Integer.MAX_VALUE");
        }
        if (remainingRecordSize == 0L) {
            return new byte[0];
        }
        int dataSize = (int)remainingDataSize;
        int recordSize = (int)remainingRecordSize;
        byte[] arr = new byte[dataSize + initialBytes.length];
        System.arraycopy(initialBytes, 0, arr, 0, initialBytes.length);
        IOUtils.readFully(leis, arr, initialBytes.length, dataSize);
        IOUtils.skipFully(leis, recordSize - dataSize);
        return arr;
    }

    private byte[] readToByteArray(LittleEndianInputStream leis, long dataSize, long recordSize) throws IOException {
        assert (dataSize < Integer.MAX_VALUE);
        if (recordSize == 0L) {
            return new byte[0];
        }
        byte[] arr = new byte[(int)dataSize];
        IOUtils.readFully(leis, arr);
        IOUtils.skipFully(leis, recordSize - dataSize);
        return arr;
    }

    public AbstractHemfComment getComment() {
        return this.comment;
    }

    private static class CommentPublicParser {
        private static final long WINDOWS_METAFILE = 0x80000001L;
        private static final long BEGINGROUP = 2L;
        private static final long ENDGROUP = 3L;
        private static final long MULTIFORMATS = 0x40000004L;
        private static final long UNICODE_STRING = 64L;
        private static final long UNICODE_END = 128L;

        private CommentPublicParser() {
        }

        private static AbstractHemfComment parse(byte[] bytes) {
            long publicCommentIdentifier = LittleEndian.getUInt(bytes, 0);
            if (publicCommentIdentifier == 0x80000001L) {
                return new HemfCommentPublic.WindowsMetafile(bytes);
            }
            if (publicCommentIdentifier == 2L) {
                return new HemfCommentPublic.BeginGroup(bytes);
            }
            if (publicCommentIdentifier == 3L) {
                return new HemfCommentPublic.EndGroup(bytes);
            }
            if (publicCommentIdentifier == 0x40000004L) {
                return new HemfCommentPublic.MultiFormats(bytes);
            }
            if (publicCommentIdentifier == 64L || publicCommentIdentifier == 128L) {
                throw new RuntimeException("UNICODE_STRING/UNICODE_END values are reserved in CommentPublic records");
            }
            throw new RuntimeException("Unrecognized public comment type:" + publicCommentIdentifier + " ; " + 0x80000001L);
        }
    }
}

