/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.parsers;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.Chunks;
import org.apache.poi.hsmf.datatypes.DirectoryChunk;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.MessagePropertiesChunk;
import org.apache.poi.hsmf.datatypes.MessageSubmissionChunk;
import org.apache.poi.hsmf.datatypes.NameIdChunks;
import org.apache.poi.hsmf.datatypes.RecipientChunks;
import org.apache.poi.hsmf.datatypes.StoragePropertiesChunk;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.datatypes.Types;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class POIFSChunkParser {
    private static final POILogger logger = POILogFactory.getLogger(POIFSChunkParser.class);

    public static ChunkGroup[] parse(NPOIFSFileSystem fs) throws IOException {
        return POIFSChunkParser.parse(fs.getRoot());
    }

    public static ChunkGroup[] parse(DirectoryNode node) throws IOException {
        Chunks mainChunks = new Chunks();
        ArrayList<ChunkGroup> groups = new ArrayList<ChunkGroup>();
        groups.add(mainChunks);
        for (Entry entry : node) {
            if (!(entry instanceof DirectoryNode)) continue;
            DirectoryNode dir = (DirectoryNode)entry;
            ChunkGroup group = null;
            if (dir.getName().startsWith("__attach_version1.0_#")) {
                group = new AttachmentChunks(dir.getName());
            }
            if (dir.getName().startsWith("__nameid_version1.0")) {
                group = new NameIdChunks();
            }
            if (dir.getName().startsWith("__recip_version1.0_#")) {
                group = new RecipientChunks(dir.getName());
            }
            if (group == null) continue;
            POIFSChunkParser.processChunks(dir, group);
            groups.add(group);
        }
        POIFSChunkParser.processChunks(node, mainChunks);
        for (ChunkGroup group : groups) {
            group.chunksComplete();
        }
        return groups.toArray(new ChunkGroup[groups.size()]);
    }

    protected static void processChunks(DirectoryNode node, ChunkGroup grouping) {
        for (Entry entry : node) {
            if (entry instanceof DocumentNode) {
                POIFSChunkParser.process(entry, grouping);
                continue;
            }
            if (!(entry instanceof DirectoryNode) || !entry.getName().endsWith(Types.DIRECTORY.asFileEnding())) continue;
            POIFSChunkParser.process(entry, grouping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void process(Entry entry, ChunkGroup grouping) {
        String entryName = entry.getName();
        Chunk chunk = null;
        if (entryName.equals("__properties_version1.0")) {
            chunk = grouping instanceof Chunks ? new MessagePropertiesChunk(grouping) : new StoragePropertiesChunk(grouping);
        } else {
            if (entryName.length() < 9) {
                return;
            }
            if (entryName.indexOf(95) == -1) {
                return;
            }
            int splitAt = entryName.lastIndexOf(95);
            String namePrefix = entryName.substring(0, splitAt + 1);
            String ids = entryName.substring(splitAt + 1);
            if (namePrefix.equals("Olk10SideProps") || namePrefix.equals("Olk10SideProps_")) {
                return;
            }
            if (splitAt > entryName.length() - 8) {
                throw new IllegalArgumentException("Invalid chunk name " + entryName);
            }
            try {
                int chunkId = Integer.parseInt(ids.substring(0, 4), 16);
                int typeId = Integer.parseInt(ids.substring(4, 8), 16);
                Types.MAPIType type = Types.getById(typeId);
                if (type == null) {
                    type = Types.createCustom(typeId);
                }
                if (chunkId == MAPIProperty.MESSAGE_SUBMISSION_ID.id) {
                    chunk = new MessageSubmissionChunk(namePrefix, chunkId, type);
                } else if (type == Types.BINARY) {
                    chunk = new ByteChunk(namePrefix, chunkId, type);
                } else if (type == Types.DIRECTORY) {
                    if (entry instanceof DirectoryNode) {
                        chunk = new DirectoryChunk((DirectoryNode)entry, namePrefix, chunkId, type);
                    }
                } else if (type == Types.ASCII_STRING || type == Types.UNICODE_STRING) {
                    chunk = new StringChunk(namePrefix, chunkId, type);
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        if (chunk != null) {
            if (entry instanceof DocumentNode) {
                DocumentInputStream inp = null;
                try {
                    inp = new DocumentInputStream((DocumentNode)entry);
                    ((Chunk)chunk).readValue(inp);
                    grouping.record(chunk);
                }
                catch (IOException e) {
                    logger.log(7, "Error reading from part " + entry.getName() + " - " + e.toString());
                }
                finally {
                    if (inp != null) {
                        inp.close();
                    }
                }
            } else {
                grouping.record(chunk);
            }
        }
    }
}

