/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.launcher.internal;

import java.io.PrintStream;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;

public final class CLIUtils {
    public static final String RESET = "\u001b[0m";
    public static final String BLACK = "\u001b[30;40;1m";
    public static final String RED = "\u001b[31;40;1m";
    public static final String GREEN = "\u001b[32;40;1m";
    public static final String YELLOW = "\u001b[33;40;1m";
    public static final String BLUE = "\u001b[34;40;1m";
    public static final String PURPLE = "\u001b[35;40;1m";
    public static final String CYAN = "\u001b[36;40;1m";
    public static final String WHITE = "\u001b[37;40;1m";
    private static CLIDecorator decorator;

    private CLIUtils() {
    }

    public static CLIDecorator getDecorator() {
        if (decorator == null) {
            String colorTerm = System.getenv().get("COLORTERM");
            decorator = colorTerm != null && "1".equals(colorTerm) ? new CLIDecorator() : new NoDecoration();
        }
        return decorator;
    }

    public static class CLIDecorator {
        public String red(String txt) {
            return CLIUtils.RED + txt + CLIUtils.RESET;
        }

        public String black(String txt) {
            return CLIUtils.BLACK + txt + CLIUtils.RESET;
        }

        public String green(String txt) {
            return CLIUtils.GREEN + txt + CLIUtils.RESET;
        }

        public String yellow(String txt) {
            return CLIUtils.YELLOW + txt + CLIUtils.RESET;
        }

        public String blue(String txt) {
            return CLIUtils.BLUE + txt + CLIUtils.RESET;
        }

        public String purple(String txt) {
            return CLIUtils.PURPLE + txt + CLIUtils.RESET;
        }

        public String cyan(String txt) {
            return CLIUtils.CYAN + txt + CLIUtils.RESET;
        }

        public String white(String txt) {
            return CLIUtils.WHITE + txt + CLIUtils.RESET;
        }
    }

    public static class ColoredPrinting
    extends BasicMonitor {
        protected PrintStream printStream;

        public ColoredPrinting(PrintStream printStream) {
            this.printStream = printStream;
        }

        public void beginTask(String name, int totalWork) {
            if (name != null && name.length() != 0) {
                this.printStream.println("\u001b[34;40;1m>>> " + name + CLIUtils.WHITE);
            }
        }

        public void setTaskName(String name) {
            if (name != null && name.length() != 0) {
                this.printStream.println("<>> " + name);
            }
        }

        public void subTask(String name) {
            if (name != null && name.length() != 0) {
                this.printStream.println("\u001b[36;40;1m>>  " + name + CLIUtils.WHITE);
            }
        }

        public void setBlocked(Diagnostic reason) {
            super.setBlocked(reason);
            this.printStream.println("\u001b[31;40;1m#>  " + reason.getMessage() + CLIUtils.WHITE);
        }

        public void clearBlocked() {
            this.printStream.println("\u001b[32;40;1m=>  " + this.getBlockedReason().getMessage() + CLIUtils.WHITE);
            super.clearBlocked();
        }
    }

    public static class NoDecoration
    extends CLIDecorator {
        @Override
        public String red(String txt) {
            return txt;
        }

        @Override
        public String black(String txt) {
            return txt;
        }

        @Override
        public String green(String txt) {
            return txt;
        }

        @Override
        public String yellow(String txt) {
            return txt;
        }

        @Override
        public String blue(String txt) {
            return txt;
        }

        @Override
        public String purple(String txt) {
            return txt;
        }

        @Override
        public String cyan(String txt) {
            return txt;
        }

        @Override
        public String white(String txt) {
            return txt;
        }
    }
}

