/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.genconf.BooleanDefinition;
import org.obeonetwork.m2doc.genconf.Definition;
import org.obeonetwork.m2doc.genconf.GenconfFactory;
import org.obeonetwork.m2doc.genconf.GenconfPackage;
import org.obeonetwork.m2doc.genconf.GenconfPlugin;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.genconf.IntegerDefinition;
import org.obeonetwork.m2doc.genconf.ModelDefinition;
import org.obeonetwork.m2doc.genconf.Option;
import org.obeonetwork.m2doc.genconf.RealDefinition;
import org.obeonetwork.m2doc.genconf.StringDefinition;
import org.obeonetwork.m2doc.genconf.provider.ConfigurationProviderService;
import org.obeonetwork.m2doc.genconf.provider.IConfigurationProvider;
import org.obeonetwork.m2doc.generator.DocumentGenerationException;
import org.obeonetwork.m2doc.ide.M2DocPlugin;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.util.IClassProvider;
import org.obeonetwork.m2doc.util.M2DocUtils;

public final class GenconfUtils {
    public static final String GENCONF_EXTENSION_FILE = "genconf";
    public static final String GENCONF_URI_OPTION = "GenconfURI";
    public static final String TEMPLATE_URI_OPTION = "TemplateURI";
    public static final String RESULT_URI_OPTION = "ResultURI";

    static {
        M2DocPlugin.INSTANCE.getBaseURL();
    }

    private GenconfUtils() {
    }

    public static Map<String, String> getOptions(Generation generation) {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        Resource eResource = generation.eResource();
        if (eResource != null && eResource.getURI() != null) {
            res.put(GENCONF_URI_OPTION, eResource.getURI().toString());
        }
        if (generation.getTemplateFileName() != null) {
            res.put(TEMPLATE_URI_OPTION, generation.getTemplateFileName());
        }
        if (generation.getResultFileName() != null) {
            res.put(RESULT_URI_OPTION, generation.getResultFileName());
        }
        for (Option option : generation.getOptions()) {
            res.put(option.getName(), option.getValue());
        }
        return res;
    }

    public static void initializeOptions(Generation generation) {
        Map<String, String> options = GenconfUtils.getOptions(generation);
        Map initializedOptions = M2DocUtils.getInitializedOptions(options);
        for (Option option : generation.getOptions()) {
            if (!initializedOptions.containsKey(option.getName())) continue;
            option.setValue((String)initializedOptions.remove(option.getName()));
        }
        for (Map.Entry entry : initializedOptions.entrySet()) {
            Option option = GenconfPackage.eINSTANCE.getGenconfFactory().createOption();
            option.setName((String)entry.getKey());
            option.setValue((String)entry.getValue());
            generation.getOptions().add((Object)option);
        }
    }

    public static IQueryEnvironment getQueryEnvironment(Generation generation) {
        URI templateURI = GenconfUtils.getResolvedURI(generation, URI.createURI((String)generation.getTemplateFileName()));
        IQueryEnvironment queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
        Map<String, String> options = GenconfUtils.getOptions(generation);
        M2DocUtils.prepareEnvironmentServices((IQueryEnvironment)queryEnvironment, (URI)templateURI, options);
        return queryEnvironment;
    }

    public static Map<String, Object> getVariables(Generation generation, ResourceSet resourceSet) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Definition def : generation.getDefinitions()) {
            if (def instanceof ModelDefinition) {
                EObject val;
                block8: {
                    URI uri = EcoreUtil.getURI((EObject)((ModelDefinition)def).getValue());
                    val = null;
                    try {
                        val = resourceSet.getEObject(uri, true);
                    }
                    catch (WrappedException wrappedException) {
                        if (((ModelDefinition)def).getValue() == null) break block8;
                        InternalEObject eobj = (InternalEObject)EcoreUtil.create((EClass)((ModelDefinition)def).getValue().eClass());
                        eobj.eSetProxyURI(uri);
                        val = eobj;
                    }
                }
                result.put(((ModelDefinition)def).getKey(), val);
                continue;
            }
            if (def instanceof StringDefinition) {
                result.put(((StringDefinition)def).getKey(), ((StringDefinition)def).getValue());
                continue;
            }
            if (def instanceof IntegerDefinition) {
                result.put(((IntegerDefinition)def).getKey(), ((IntegerDefinition)def).getValue());
                continue;
            }
            if (def instanceof RealDefinition) {
                result.put(((RealDefinition)def).getKey(), ((RealDefinition)def).getValue());
                continue;
            }
            if (def instanceof BooleanDefinition) {
                result.put(((BooleanDefinition)def).getKey(), ((BooleanDefinition)def).isValue());
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return result;
    }

    public static List<Definition> getNewDefinitions(Generation generation, TemplateCustomProperties templateCustomProperties) {
        IQueryEnvironment queryEnvironment = Query.newEnvironment();
        queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        queryEnvironment.registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
        templateCustomProperties.configureQueryEnvironment(queryEnvironment);
        AstValidator validator = new AstValidator(new ValidationServices((IReadOnlyQueryEnvironment)queryEnvironment));
        Map variablesTypes = templateCustomProperties.getVariableTypes(validator, (IReadOnlyQueryEnvironment)queryEnvironment);
        HashSet<String> existingVariables = new HashSet<String>();
        for (Definition definition : generation.getDefinitions()) {
            if (!GenconfUtils.isValidDefinitionForType((IReadOnlyQueryEnvironment)queryEnvironment, definition, (Set)variablesTypes.get(definition.getKey()))) continue;
            existingVariables.add(definition.getKey());
        }
        ArrayList<Definition> newDefinitions = new ArrayList<Definition>();
        for (Map.Entry entry : variablesTypes.entrySet()) {
            Definition newDefinition;
            if (existingVariables.contains(entry.getKey()) || (newDefinition = GenconfUtils.createDefinition((IReadOnlyQueryEnvironment)queryEnvironment, (String)entry.getKey(), (Set)entry.getValue())) == null) continue;
            newDefinitions.add(newDefinition);
        }
        return newDefinitions;
    }

    private static Definition createDefinition(IReadOnlyQueryEnvironment queryEnvironment, String name, Set<IType> types) {
        Definition res = null;
        ClassType eObjectType = new ClassType(queryEnvironment, EObject.class);
        ClassType stringType = new ClassType(queryEnvironment, String.class);
        for (IType type : types) {
            if (eObjectType.isAssignableFrom(type)) {
                res = GenconfPackage.eINSTANCE.getGenconfFactory().createModelDefinition();
                res.setKey(name);
                break;
            }
            if (!stringType.isAssignableFrom(type)) continue;
            res = GenconfPackage.eINSTANCE.getGenconfFactory().createStringDefinition();
            res.setKey(name);
            break;
        }
        return res;
    }

    private static boolean isValidDefinitionForType(IReadOnlyQueryEnvironment queryEnvironment, Definition definition, Set<IType> types) {
        boolean res = false;
        ClassType eObjectType = new ClassType(queryEnvironment, EObject.class);
        ClassType stringType = new ClassType(queryEnvironment, String.class);
        ClassType integerType = new ClassType(queryEnvironment, Integer.class);
        ClassType realType = new ClassType(queryEnvironment, Double.class);
        ClassType booleanType = new ClassType(queryEnvironment, Boolean.class);
        for (IType type : types) {
            if (eObjectType.isAssignableFrom(type) && definition instanceof ModelDefinition) {
                res = true;
                break;
            }
            if (stringType.isAssignableFrom(type) && definition instanceof StringDefinition) {
                res = true;
                break;
            }
            if (integerType.isAssignableFrom(type) && definition instanceof IntegerDefinition) {
                res = true;
                break;
            }
            if (realType.isAssignableFrom(type) && definition instanceof RealDefinition) {
                res = true;
                break;
            }
            if (!booleanType.isAssignableFrom(type) || !(definition instanceof BooleanDefinition)) continue;
            res = true;
            break;
        }
        return res;
    }

    public static List<URI> generate(Generation generation, IClassProvider classProvider, Monitor monitor) throws DocumentGenerationException, IOException, DocumentParserException {
        if (generation == null) {
            throw new IllegalArgumentException("Null configuration object passed.");
        }
        String templateFilePath = generation.getTemplateFileName();
        if (templateFilePath == null) {
            throw new DocumentGenerationException("The template file path isn't set in the provided configuration");
        }
        String resultFilePath = generation.getResultFileName();
        if (resultFilePath == null) {
            throw new DocumentGenerationException("The result file path isn't set in the provided configuration");
        }
        URI templateFile = GenconfUtils.getResolvedURI(generation, URI.createURI((String)generation.getTemplateFileName()));
        URI generatedFile = GenconfUtils.getResolvedURI(generation, URI.createURI((String)generation.getResultFileName()));
        if (!URIConverter.INSTANCE.exists(templateFile, Collections.EMPTY_MAP)) {
            throw new DocumentGenerationException("The template file doest not exist " + templateFilePath);
        }
        return GenconfUtils.generate(generation, classProvider, templateFile, generatedFile, monitor);
    }

    public static URI getResolvedURI(Generation generation, URI uri) {
        URI res = generation.eResource() != null && generation.eResource().getURI() != null ? uri.resolve(generation.eResource().getURI()) : uri;
        return res;
    }

    private static List<URI> generate(Generation generation, IClassProvider classProvider, URI templateURI, URI generatedURI, Monitor monitor) throws IOException, DocumentParserException, DocumentGenerationException {
        IQueryEnvironment queryEnvironment = GenconfUtils.getQueryEnvironment(generation);
        monitor.beginTask("Loading models.", 2);
        ResourceSet resourceSetForModels = GenconfUtils.createResourceSetForModels(generation);
        monitor.worked(1);
        Map<String, Object> definitions = GenconfUtils.getVariables(generation, resourceSetForModels);
        monitor.done();
        Throwable throwable = null;
        Object var9_10 = null;
        try (DocumentTemplate template = M2DocUtils.parse((URI)templateURI, (IQueryEnvironment)queryEnvironment, (IClassProvider)classProvider);){
            monitor.beginTask("Validating template.", 1);
            URI validationURI = GenconfUtils.validate(generatedURI, template, (IReadOnlyQueryEnvironment)queryEnvironment, generation);
            monitor.done();
            M2DocUtils.generate((DocumentTemplate)template, (IReadOnlyQueryEnvironment)queryEnvironment, definitions, (URI)generatedURI, (Monitor)monitor);
            ArrayList<URI> generatedFiles = new ArrayList<URI>();
            generatedFiles.add(generatedURI);
            if (validationURI != null) {
                URI validationFile = validationURI;
                generatedFiles.add(validationFile);
            }
            return generatedFiles;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static ResourceSet createResourceSetForModels(Generation generation) {
        ResourceSetImpl created = null;
        Iterator<IConfigurationProvider> it = ConfigurationProviderService.getInstance().getProviders().iterator();
        while (created == null && it.hasNext()) {
            IConfigurationProvider cur = it.next();
            created = cur.createResourceSetForModels(generation);
        }
        if (created == null) {
            created = new ResourceSetImpl();
            created.getPackageRegistry().put((Object)"http://www.obeonetwork.org/m2doc/genconf/1.0", (Object)GenconfPackage.eINSTANCE);
            created.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        }
        return created;
    }

    public static boolean validate(Generation generation, IClassProvider classProvider) throws IOException, DocumentParserException, DocumentGenerationException {
        boolean res;
        String templateFilePath = generation.getTemplateFileName();
        if (templateFilePath == null) {
            throw new DocumentGenerationException("The template file path isn't set in the provided configuration");
        }
        URI templateURI = GenconfUtils.getResolvedURI(generation, URI.createURI((String)generation.getTemplateFileName()));
        if (!URIConverter.INSTANCE.exists(templateURI, Collections.EMPTY_MAP)) {
            throw new DocumentGenerationException("The template file does not exist " + templateFilePath);
        }
        IQueryEnvironment queryEnvironment = GenconfUtils.getQueryEnvironment(generation);
        Throwable throwable = null;
        Object var7_7 = null;
        try (DocumentTemplate template = M2DocUtils.parse((URI)templateURI, (IQueryEnvironment)queryEnvironment, (IClassProvider)classProvider);){
            res = template != null ? GenconfUtils.validate(templateURI, template, (IReadOnlyQueryEnvironment)queryEnvironment, generation) != null : true;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return res;
    }

    private static URI validate(URI templateURI, DocumentTemplate documentTemplate, IReadOnlyQueryEnvironment queryEnvironment, Generation generation) throws DocumentGenerationException, IOException {
        URI res;
        ValidationMessageLevel validationLevel = M2DocUtils.validate((DocumentTemplate)documentTemplate, (IReadOnlyQueryEnvironment)queryEnvironment);
        if (validationLevel != ValidationMessageLevel.OK) {
            res = GenconfUtils.getValidationLogFile(templateURI, validationLevel);
            M2DocUtils.serializeValidatedDocumentTemplate((DocumentTemplate)documentTemplate, (URI)res);
        } else {
            res = null;
        }
        return res;
    }

    private static URI getValidationLogFile(URI templateURI, ValidationMessageLevel level) {
        String lastSegmentNoExtension = templateURI.lastSegment().replaceFirst("[.][^.]+$", "");
        URI uri = templateURI.trimSegments(1).appendSegment(String.valueOf(lastSegmentNoExtension) + "-" + level.name().toLowerCase());
        URI res = URI.validSegment((String)templateURI.fileExtension()) ? uri.appendFileExtension(templateURI.fileExtension()) : uri;
        return res;
    }

    public static Resource createConfigurationModel(URI templateURI) throws IOException {
        Resource resource = null;
        TemplateCustomProperties templateProperties = POIServices.getInstance().getTemplateCustomProperties(URIConverter.INSTANCE, templateURI);
        if (templateProperties != null) {
            resource = GenconfUtils.createConfigurationModel(templateProperties, templateURI);
        }
        return resource;
    }

    private static Resource createResource(URI templateFile, URI genConfURI) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(genConfURI);
        return resource;
    }

    private static Resource createConfigurationModel(TemplateCustomProperties templateProperties, URI templateURI) {
        URI genConfURI = templateURI.trimFileExtension().appendFileExtension(GENCONF_EXTENSION_FILE);
        Resource resource = GenconfUtils.createResource(templateURI, genConfURI);
        Generation generation = GenconfUtils.createInitialModel(genConfURI.trimFileExtension().lastSegment(), templateURI.deresolve(genConfURI).toString());
        List<Definition> definitions = GenconfUtils.getNewDefinitions(generation, templateProperties);
        generation.getDefinitions().addAll(definitions);
        if (generation != null) {
            resource.getContents().add((Object)generation);
        }
        try {
            GenconfUtils.saveResource(resource);
        }
        catch (IOException e) {
            GenconfPlugin.INSTANCE.log(new Status(4, "org.obeonetwork.m2doc.genconf", 4, e.getMessage(), (Throwable)e));
        }
        try {
            GenconfUtils.saveResource(resource);
        }
        catch (IOException e) {
            GenconfPlugin.INSTANCE.log(new Status(4, "org.obeonetwork.m2doc.genconf", 4, e.getMessage(), (Throwable)e));
        }
        return resource;
    }

    private static Generation createInitialModel(String name, String templateFileName) {
        Generation generation = GenconfFactory.eINSTANCE.createGeneration();
        generation.setName(URI.decode((String)name));
        generation.setTemplateFileName(URI.decode((String)templateFileName));
        return generation;
    }

    private static void saveResource(Resource resource) throws IOException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        resource.save(options);
    }
}

