/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.obeonetwork.m2doc.genconf.provider.IConfigurationProvider;

public final class ConfigurationProviderService {
    private static final String CONFIGURATION_ELEMENT_NAME = "configuration";
    private static final String PROVIDER_CLASS_ATTR_NAME = "providerClass";
    private static ConfigurationProviderService instance = new ConfigurationProviderService();
    private List<IConfigurationProvider> providers = new ArrayList<IConfigurationProvider>();

    private ConfigurationProviderService() {
        this.configureService();
    }

    public static ConfigurationProviderService getInstance() {
        return instance;
    }

    public List<IConfigurationProvider> getProviders() {
        return this.providers;
    }

    public void register(IConfigurationProvider provider) {
        this.providers.add(provider);
    }

    private void configureService() {
        IExtensionPoint extensionPoint;
        if (Platform.getExtensionRegistry() != null && (extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.obeonetwork.m2doc.genconf", CONFIGURATION_ELEMENT_NAME)) != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int extensionIndex = 0;
            while (extensionIndex < extensions.length) {
                IExtension extension = extensions[extensionIndex];
                IConfigurationElement[] configurationElements = extension.getConfigurationElements();
                int i = 0;
                while (i < configurationElements.length) {
                    IConfigurationElement cfg = configurationElements[i];
                    if (CONFIGURATION_ELEMENT_NAME.equals(cfg.getName())) {
                        try {
                            this.register((IConfigurationProvider)cfg.createExecutableExtension(PROVIDER_CLASS_ATTR_NAME));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
                ++extensionIndex;
            }
        }
    }
}

